/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.latex.generator;

import adams.core.base.BaseText;
import adams.doc.latex.generator.AbstractEnvironmentWithNoTrailingSpace;

public class Verbatim
extends AbstractEnvironmentWithNoTrailingSpace {
    private static final long serialVersionUID = 7225514457280622837L;
    protected BaseText m_Statements;

    public String globalInfo() {
        return "Outputs the specified statements in a verbatim block. Variables get expanded.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statements", "statements", (Object)new BaseText());
    }

    public void setStatements(BaseText value) {
        this.m_Statements = value;
        this.reset();
    }

    public BaseText getStatements() {
        return this.m_Statements;
    }

    public String statementsTipText() {
        return "The statements to insert as verbatim block.";
    }

    @Override
    public String[] getRequiredPackages() {
        return new String[0];
    }

    @Override
    protected String doGenerate() {
        StringBuilder result = new StringBuilder();
        result.append("\\begin{verbatim}\n");
        result.append(this.expand(this.m_Statements.getValue()));
        this.ensureTrailingNewLine(result);
        result.append("\\end{verbatim}");
        if (this.m_SuppressTrailingSpace) {
            result.append("%");
        }
        result.append("\n");
        return result.toString();
    }
}

