/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.management.ProcessUtils;
import adams.doc.latex.LatexHelper;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.source.filesystemsearch.LocalFileSearch;
import adams.flow.standalone.LatexSetup;
import adams.flow.transformer.AbstractTransformer;
import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LatexCompile
extends AbstractTransformer {
    private static final long serialVersionUID = -2873331108505370869L;
    public static final String RERUN_OUTLINES = "Rerun to get outlines right";
    public static final String RERUN_CROSSREF = "Rerun to get cross-references right";
    public static final String RERUN_CITATIONS = "Rerun to get citations correct";
    public static final String EMERGENCY_STOP = "Emergency stop";
    public static final String[] TMP_EXT = new String[]{".aux", ".lof", ".out", ".toc", ".bbl"};
    protected LatexSetup m_LatexSetup;
    protected transient CollectingProcessOutput m_ProcessOutput;

    public String globalInfo() {
        return "Compiles the incoming LaTeX document (file name). Outputs the error if failed to compile.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_LatexSetup = (LatexSetup)ActorUtils.findClosestType((Actor)this, LatexSetup.class, (boolean)true);
        }
        return result;
    }

    protected String doExecute() {
        List list;
        String options;
        Object bibtex;
        Object exec;
        String result = null;
        String latex = this.m_InputToken.getPayload() instanceof File ? ((File)this.m_InputToken.getPayload()).getAbsolutePath() : new PlaceholderFile((String)this.m_InputToken.getPayload()).getAbsolutePath();
        PlaceholderDirectory cwd = new PlaceholderDirectory(new PlaceholderFile(latex).getParentFile());
        String log = FileUtils.replaceExtension((String)latex, (String)".log");
        if (this.m_LatexSetup == null) {
            exec = LatexHelper.getBinariesDir() + File.separator + LatexHelper.getExecutable();
            bibtex = LatexHelper.getBinariesDir() + File.separator + LatexHelper.getBibtex();
            options = LatexHelper.getExecutableOptions();
        } else {
            exec = this.m_LatexSetup.executablePath();
            bibtex = this.m_LatexSetup.bibtexPath();
            options = this.m_LatexSetup.getExecutableOptions();
        }
        for (String ext : TMP_EXT) {
            String tmp = FileUtils.replaceExtension((String)latex, (String)ext);
            if (!FileUtils.fileExists((String)tmp)) continue;
            FileUtils.delete((String)tmp);
        }
        LocalFileSearch search = new LocalFileSearch();
        search.setDirectory(new PlaceholderDirectory(new File(latex).getParentFile()));
        search.setRegExp(new BaseRegExp(".*\\.bib"));
        search.setRecursive(false);
        try {
            list = search.search();
            for (String file : list) {
                this.m_ProcessOutput = ProcessUtils.execute((String[])new String[]{bibtex, file}, (PlaceholderDirectory)cwd);
                if (this.m_ProcessOutput.hasSucceeded()) continue;
                result = ProcessUtils.toErrorOutput((CollectingProcessOutput)this.m_ProcessOutput);
                break;
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to check for bibtex file(s)!", e);
        }
        this.m_ProcessOutput = null;
        if (result == null) {
            ArrayList<Object> cmdline = new ArrayList<Object>();
            cmdline.add(exec);
            if (!options.isEmpty()) {
                cmdline.addAll(Arrays.asList(options.split(" ")));
            }
            cmdline.add(latex);
            boolean compiling = true;
            while (compiling) {
                try {
                    this.m_ProcessOutput = ProcessUtils.execute((String[])cmdline.toArray(new String[cmdline.size()]), (PlaceholderDirectory)cwd);
                    compiling = false;
                    if (this.m_ProcessOutput.hasSucceeded() && FileUtils.fileExists((String)log)) {
                        list = FileUtils.loadFromFile((File)new PlaceholderFile(log));
                        for (String line : list) {
                            if (line.contains(RERUN_CITATIONS) || line.contains(RERUN_CROSSREF) || line.contains(RERUN_OUTLINES)) {
                                compiling = true;
                                continue;
                            }
                            if (!line.contains(EMERGENCY_STOP)) continue;
                            compiling = false;
                            result = ProcessUtils.toErrorOutput((CollectingProcessOutput)this.m_ProcessOutput);
                        }
                    }
                }
                catch (Exception e) {
                    compiling = false;
                    result = this.handleException("Failed to compile LaTeX document: " + latex, e);
                }
                this.m_ProcessOutput = null;
            }
        }
        return result;
    }

    public void stopExecution() {
        if (this.m_ProcessOutput != null) {
            this.m_ProcessOutput.destroy();
        }
        super.stopExecution();
    }
}

