/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.data.gps.Coordinate;
import adams.data.gps.GPSDecimalMinutes;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class GPSDecimalMinutesTest
extends AdamsTestCase {
    public GPSDecimalMinutesTest(String name) {
        super(name);
    }

    protected void performFromStringTest(String s, double lat, double lon, boolean swapped) {
        GPSDecimalMinutes gpsAct = new GPSDecimalMinutes(s, swapped);
        GPSDecimalMinutes gpsRef = new GPSDecimalMinutes(new Coordinate(lat), new Coordinate(lon));
        GPSDecimalMinutesTest.assertEquals((String)"Latitude differs", (Object)gpsRef.getLatitude().toDecimal(), (Object)gpsAct.getLatitude().toDecimal());
        GPSDecimalMinutesTest.assertEquals((String)"Longitude differs", (Object)gpsRef.getLongitude().toDecimal(), (Object)gpsAct.getLongitude().toDecimal());
    }

    public void testFromString() {
        this.performFromStringTest("N 51 12.6 W0 35.4", 51.21, 0.59, false);
        this.performFromStringTest("N 51 12.6 E0 35.4", 51.21, -0.59, false);
        this.performFromStringTest("S51 12.6 0 35.4", -51.21, 0.59, false);
        this.performFromStringTest("S51 12.6 E0 35.4", -51.21, -0.59, false);
        this.performFromStringTest("W0 35.4 N 51 12.6", 51.21, 0.59, true);
        this.performFromStringTest("E0 35.4 N 51 12.6", 51.21, -0.59, true);
        this.performFromStringTest("0 35.4 S51 12.6", -51.21, 0.59, true);
        this.performFromStringTest("E0 35.4 S51 12.6", -51.21, -0.59, true);
    }

    protected void performToStringTest(double lat, double lon, String s) {
        GPSDecimalMinutes gps = new GPSDecimalMinutes(new Coordinate(lat), new Coordinate(lon));
        GPSDecimalMinutesTest.assertEquals((String)"String differs", (String)s, (String)gps.toString());
    }

    public void testToString() {
        this.performToStringTest(51.21, 0.59, "N51 12.6 W0 35.4");
        this.performToStringTest(51.21, -0.59, "N51 12.6 E0 35.4");
        this.performToStringTest(-51.21, -0.59, "S51 12.6 E0 35.4");
    }

    public static Test suite() {
        return new TestSuite(GPSDecimalMinutesTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        GPSDecimalMinutesTest.runTest((Test)GPSDecimalMinutesTest.suite());
    }
}

