/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.core.Utils;
import adams.data.gps.AbstractGPS;
import adams.data.gps.Coordinate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GPSDecimalMinutes
extends AbstractGPS {
    private static final long serialVersionUID = 8682798854401575189L;
    public static final String FORMAT = "([NnSs\\+-]?)\\s*(\\d+)\\s+(\\d+)\\.(\\d+)[\\s,]*([WwEe\\+-]?)\\s*(\\d+)\\s+(\\d+)\\.(\\d+)";
    public static final String FORMAT_SWAPPED = "([WwEe\\+-]?)\\s*(\\d+)\\s+(\\d+)\\.(\\d+)[\\s,]*([NnSs\\+-]?)\\s*(\\d+)\\s+(\\d+)\\.(\\d+)";

    public GPSDecimalMinutes() {
    }

    public GPSDecimalMinutes(String s) {
        super(s);
    }

    public GPSDecimalMinutes(String s, boolean swapped) {
        super(s, swapped);
    }

    public GPSDecimalMinutes(AbstractGPS gps) {
        super(gps);
    }

    public GPSDecimalMinutes(double lat, double lon) {
        super(lat, lon);
    }

    public GPSDecimalMinutes(Coordinate lat, Coordinate lon) {
        super(lat, lon);
    }

    @Override
    protected GPSDecimalMinutes clone() {
        return new GPSDecimalMinutes(this);
    }

    @Override
    protected Coordinate[] parse(String s, boolean swapped) {
        Coordinate[] result = null;
        s = this.preprocess(s);
        Pattern pattern = swapped ? Pattern.compile(FORMAT_SWAPPED) : Pattern.compile(FORMAT);
        Matcher matcher = pattern.matcher(s);
        double latsign = 1.0;
        double longsign = 1.0;
        if (matcher.matches()) {
            String slatsign = matcher.group(1);
            String slongsign = matcher.group(5);
            if (swapped) {
                if (slongsign.equalsIgnoreCase("S") || slongsign.equals("-")) {
                    longsign = -1.0;
                }
                if (slatsign.equalsIgnoreCase("E") || slatsign.equals("-")) {
                    latsign = -1.0;
                }
            } else {
                if (slatsign.equalsIgnoreCase("S") || slatsign.equals("-")) {
                    latsign = -1.0;
                }
                if (slongsign.equalsIgnoreCase("E") || slongsign.equals("-")) {
                    longsign = -1.0;
                }
            }
            double latdegrees = Integer.parseInt(matcher.group(2));
            double longdegrees = Integer.parseInt(matcher.group(6));
            latdegrees += Double.parseDouble(matcher.group(3) + "." + matcher.group(4)) / 60.0;
            longdegrees += Double.parseDouble(matcher.group(7) + "." + matcher.group(8)) / 60.0;
            result = swapped ? new Coordinate[]{new Coordinate(longdegrees), new Coordinate(latdegrees)} : new Coordinate[]{new Coordinate(latdegrees *= latsign), new Coordinate(longdegrees *= longsign)};
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        double lat = (double)this.m_Latitude.getMinute() + this.m_Latitude.getSecond() / 60.0;
        double lon = (double)this.m_Longitude.getMinute() + this.m_Longitude.getSecond() / 60.0;
        if (this.m_Latitude.isNegative()) {
            result.append("S");
        } else {
            result.append("N");
        }
        result.append(Integer.toString(Math.abs(this.m_Latitude.getDegree())));
        result.append(" ");
        String str = Utils.doubleToString((double)Math.abs(lat), (int)6);
        result.append(str);
        if (str.indexOf(46) == -1) {
            result.append(".0");
        }
        result.append(" ");
        if (this.m_Longitude.isNegative()) {
            result.append("E");
        } else {
            result.append("W");
        }
        result.append(Integer.toString(Math.abs(this.m_Longitude.getDegree())));
        result.append(" ");
        str = Utils.doubleToString((double)Math.abs(lon), (int)6);
        result.append(str);
        if (str.indexOf(46) == -1) {
            result.append(".0");
        }
        return result.toString();
    }
}

