/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * GPSDecimalSeconds.java
 * Copyright (C) 2013 University of Waikato, Hamilton, New Zealand
 */
package adams.data.spreadsheet;

/**
 * Handler for {@link adams.data.gps.GPSDecimalSeconds} objects.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 6814 $
 */
public class GPSDecimalSeconds
  extends AbstractObjectHandler<adams.data.gps.AbstractGPS> {

  /** for serialization. */
  private static final long serialVersionUID = 7974389418833822610L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  @Override
  public String globalInfo() {
    return "Handles instances of " + adams.data.gps.GPSDecimalSeconds.class.getName() + ".";
  }

  /**
   * Checks whether the handler can process the given class.
   * 
   * @param cls 	the class to check
   * @return		true if handler can process the class
   */
  @Override
  public boolean handles(Class cls) {
    return cls.equals(adams.data.gps.GPSDecimalSeconds.class);
  }

  /**
   * Parses the given string.
   * 
   * @param s		the string
   * @return		the generated object, null if failed to convert
   */
  @Override
  public adams.data.gps.GPSDecimalSeconds parse(String s) {
    return new adams.data.gps.GPSDecimalSeconds(s);
  }

  /**
   * Turns the given object back into a string.
   * 
   * @param obj		the object to convert into a string
   * @return		the string representation
   */
  @Override
  public String format(adams.data.gps.AbstractGPS obj) {
    if (obj instanceof adams.data.gps.GPSDecimalSeconds)
      return obj.toString();
    else
      return new adams.data.gps.GPSDecimalSeconds(obj).toString();
  }
}
