/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.data.gps.Coordinate;
import adams.data.gps.GPSDecimalDegrees;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class GPSDecimalDegreesTest
extends AdamsTestCase {
    public GPSDecimalDegreesTest(String name) {
        super(name);
    }

    public void testFromString() {
        String s = "51.20523 W0.58551";
        GPSDecimalDegrees gpsAct = new GPSDecimalDegrees(s);
        GPSDecimalDegrees gpsRef = new GPSDecimalDegrees(new Coordinate(51.20523), new Coordinate(0.58551));
        GPSDecimalDegreesTest.assertEquals((String)"Latitude differs", (Object)gpsRef.getLatitude().toDecimal(), (Object)gpsAct.getLatitude().toDecimal());
        GPSDecimalDegreesTest.assertEquals((String)"Longitude differs", (Object)gpsRef.getLongitude().toDecimal(), (Object)gpsAct.getLongitude().toDecimal());
        s = "N51.20523 E0.58551";
        gpsAct = new GPSDecimalDegrees(s);
        gpsRef = new GPSDecimalDegrees(new Coordinate(51.20523), new Coordinate(-0.58551));
        GPSDecimalDegreesTest.assertEquals((String)"Latitude differs", (Object)gpsRef.getLatitude().toDecimal(), (Object)gpsAct.getLatitude().toDecimal());
        GPSDecimalDegreesTest.assertEquals((String)"Longitude differs", (Object)gpsRef.getLongitude().toDecimal(), (Object)gpsAct.getLongitude().toDecimal());
    }

    public void testToString() {
        String s = "N51.20523 W0.58551";
        GPSDecimalDegrees gpsAct = new GPSDecimalDegrees(s);
        GPSDecimalDegrees gpsRef = new GPSDecimalDegrees(new Coordinate(51.20523), new Coordinate(0.58551));
        GPSDecimalDegreesTest.assertEquals((String)"String differs", (String)gpsRef.toString(), (String)gpsAct.toString());
        s = "51.20523 -0.58551";
        gpsAct = new GPSDecimalDegrees(s);
        gpsRef = new GPSDecimalDegrees(new Coordinate(51.20523), new Coordinate(-0.58551));
        GPSDecimalDegreesTest.assertEquals((String)"String differs", (String)gpsRef.toString(), (String)gpsAct.toString());
    }

    public static Test suite() {
        return new TestSuite(GPSDecimalDegreesTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        GPSDecimalDegreesTest.runTest((Test)GPSDecimalDegreesTest.suite());
    }
}

