/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.data.gps.Coordinate;
import adams.data.gps.GPSDecimalMinutes;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class GPSDecimalMinutesTest
extends AdamsTestCase {
    public GPSDecimalMinutesTest(String name) {
        super(name);
    }

    public void testFromString() {
        String s = "N 51 12.6 W0 35.4";
        GPSDecimalMinutes gpsAct = new GPSDecimalMinutes(s);
        GPSDecimalMinutes gpsRef = new GPSDecimalMinutes(new Coordinate(51.21), new Coordinate(0.59));
        GPSDecimalMinutesTest.assertEquals((String)"Latitude differs", (Object)gpsRef.getLatitude().toDecimal(), (Object)gpsAct.getLatitude().toDecimal());
        GPSDecimalMinutesTest.assertEquals((String)"Longitude differs", (Object)gpsRef.getLongitude().toDecimal(), (Object)gpsAct.getLongitude().toDecimal());
        s = "N 51 12.6 E0 35.4";
        gpsAct = new GPSDecimalMinutes(s);
        gpsRef = new GPSDecimalMinutes(new Coordinate(51.21), new Coordinate(-0.59));
        GPSDecimalMinutesTest.assertEquals((String)"Latitude differs", (Object)gpsRef.getLatitude().toDecimal(), (Object)gpsAct.getLatitude().toDecimal());
        GPSDecimalMinutesTest.assertEquals((String)"Longitude differs", (Object)gpsRef.getLongitude().toDecimal(), (Object)gpsAct.getLongitude().toDecimal());
    }

    public void testToString() {
        String s = "N51 12.6 W0 35.4";
        GPSDecimalMinutes gpsAct = new GPSDecimalMinutes(s);
        GPSDecimalMinutes gpsRef = new GPSDecimalMinutes(new Coordinate(51.21), new Coordinate(0.59));
        GPSDecimalMinutesTest.assertEquals((String)"String differs", (String)gpsRef.toString(), (String)gpsAct.toString());
        s = "51 12.6 E0 35.4";
        gpsAct = new GPSDecimalMinutes(s);
        gpsRef = new GPSDecimalMinutes(new Coordinate(51.21), new Coordinate(-0.59));
        GPSDecimalMinutesTest.assertEquals((String)"String differs", (String)gpsRef.toString(), (String)gpsAct.toString());
    }

    public static Test suite() {
        return new TestSuite(GPSDecimalMinutesTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        GPSDecimalMinutesTest.runTest((Test)GPSDecimalMinutesTest.suite());
    }
}

