/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.data.gps.Coordinate;
import adams.data.gps.GPSDecimalSeconds;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class GPSDecimalSecondsTest
extends AdamsTestCase {
    public GPSDecimalSecondsTest(String name) {
        super(name);
    }

    public void testFromString() {
        String s = "51 12 18.36 W0 35 7.8";
        GPSDecimalSeconds gpsAct = new GPSDecimalSeconds(s);
        GPSDecimalSeconds gpsRef = new GPSDecimalSeconds(new Coordinate(51.2051), new Coordinate(0.5855));
        GPSDecimalSecondsTest.assertEquals((String)"Latitude differs", (Object)gpsRef.getLatitude().toDecimal(), (Object)gpsAct.getLatitude().toDecimal());
        GPSDecimalSecondsTest.assertEquals((String)"Longitude differs", (Object)gpsRef.getLongitude().toDecimal(), (Object)gpsAct.getLongitude().toDecimal());
        s = "51 12 18.36 E0 35 7.8";
        gpsAct = new GPSDecimalSeconds(s);
        gpsRef = new GPSDecimalSeconds(new Coordinate(51.2051), new Coordinate(-0.5855));
        GPSDecimalSecondsTest.assertEquals((String)"Latitude differs", (Object)gpsRef.getLatitude().toDecimal(), (Object)gpsAct.getLatitude().toDecimal());
        GPSDecimalSecondsTest.assertEquals((String)"Longitude differs", (Object)gpsRef.getLongitude().toDecimal(), (Object)gpsAct.getLongitude().toDecimal());
    }

    public void testToString() {
        String s = "N51 12 18.36 W0 35 7.8";
        GPSDecimalSeconds gpsAct = new GPSDecimalSeconds(s);
        GPSDecimalSeconds gpsRef = new GPSDecimalSeconds(new Coordinate(51.2051), new Coordinate(0.5855));
        GPSDecimalSecondsTest.assertEquals((String)"String differs", (String)gpsRef.toString(), (String)gpsAct.toString());
        s = "51 12 18.36 E0 35 7.8";
        gpsAct = new GPSDecimalSeconds(s);
        gpsRef = new GPSDecimalSeconds(new Coordinate(51.2051), new Coordinate(-0.5855));
        GPSDecimalSecondsTest.assertEquals((String)"String differs", (String)gpsRef.toString(), (String)gpsAct.toString());
    }

    public static Test suite() {
        return new TestSuite(GPSDecimalSecondsTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        GPSDecimalSecondsTest.runTest((Test)GPSDecimalSecondsTest.suite());
    }
}

