/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.data.gps.Coordinate;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class CoordinateTest
extends AdamsTestCase {
    public CoordinateTest(String name) {
        super(name);
    }

    protected void performDecimalTest(double coord, int deg, int min, double sec) {
        CoordinateTest.assertEquals((String)"decimals differ", (Object)coord, (Object)new Coordinate(coord).toDecimal());
        CoordinateTest.assertEquals((String)"negative differs", (coord < 0.0 ? 1 : 0) != 0, (boolean)new Coordinate(coord).isNegative());
        CoordinateTest.assertEquals((String)"degrees differ", (int)deg, (int)new Coordinate(coord).getDegree());
        CoordinateTest.assertEquals((String)"minutes differ", (int)min, (int)new Coordinate(coord).getMinute());
        CoordinateTest.assertEquals((String)"seconds differ", (Object)sec, (Object)new Coordinate(coord).getSecond());
    }

    public void testDecimal() {
        this.performDecimalTest(51.2051, 51, 12, 18.36);
        this.performDecimalTest(-51.2051, 51, 12, 18.36);
        this.performDecimalTest(0.5855, 0, 35, 7.8);
        this.performDecimalTest(-0.5855, 0, 35, 7.8);
    }

    protected void performDegMinSecTest(boolean neg, int deg, int min, double sec, double coord) {
        CoordinateTest.assertEquals((String)"degrees differ", (int)deg, (int)new Coordinate(neg, deg, min, sec).getDegree());
        CoordinateTest.assertEquals((String)"minutes differ", (int)min, (int)new Coordinate(neg, deg, min, sec).getMinute());
        CoordinateTest.assertEquals((String)"seconds differ", (Object)sec, (Object)new Coordinate(neg, deg, min, sec).getSecond());
        CoordinateTest.assertEquals((String)"decimals differ", (Object)coord, (Object)new Coordinate(neg, deg, min, sec).toDecimal());
    }

    public void testDegMinSec() {
        this.performDegMinSecTest(false, 51, 12, 18.36, 51.2051);
        this.performDegMinSecTest(true, 51, 12, 18.36, -51.2051);
    }

    public static Test suite() {
        return new TestSuite(CoordinateTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        CoordinateTest.runTest((Test)CoordinateTest.suite());
    }
}

