/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import java.io.Serializable;

public class Coordinate
implements Serializable,
Comparable<Coordinate>,
Cloneable {
    private static final long serialVersionUID = -5163361656893487847L;
    public static final int NUM_DECIMALS = 6;
    protected boolean m_Negative;
    protected int m_Degree;
    protected int m_Minute;
    protected double m_Second;

    public Coordinate() {
        this(false, 0, 0, 0.0);
    }

    public Coordinate(boolean negative, int deg, int min, double sec) {
        this.m_Negative = negative;
        this.m_Degree = deg;
        this.m_Minute = min;
        this.m_Second = sec;
    }

    public Coordinate(double deg) {
        int intPart;
        this.m_Negative = deg < 0.0;
        deg = Math.abs(deg);
        double mod = deg % 1.0;
        int degree = intPart = (int)deg;
        deg = mod * 60.0;
        mod = deg % 1.0;
        int minute = intPart = (int)deg;
        deg = mod * 60.0;
        this.m_Degree = Math.abs(degree);
        this.m_Minute = minute;
        this.m_Second = (double)Math.round(deg * Math.pow(10.0, 6.0)) / Math.pow(10.0, 6.0);
    }

    public boolean isNegative() {
        return this.m_Negative;
    }

    public int getDegree() {
        return this.m_Degree;
    }

    public int getMinute() {
        return this.m_Minute;
    }

    public double getSecond() {
        return this.m_Second;
    }

    public double toDecimal() {
        double seconds = (double)this.m_Minute * 60.0 + this.m_Second;
        double frac = seconds / 3600.0;
        if (this.m_Negative) {
            return -((double)this.m_Degree + frac);
        }
        return (double)this.m_Degree + frac;
    }

    protected Coordinate clone() {
        return new Coordinate(this.m_Negative, this.m_Degree, this.m_Minute, this.m_Second);
    }

    @Override
    public int compareTo(Coordinate o) {
        if (o == null) {
            return 1;
        }
        int result = new Double(this.toDecimal()).compareTo(o.toDecimal());
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof Coordinate) {
            return this.compareTo((Coordinate)o) == 0;
        }
        return false;
    }

    public String toString() {
        return (this.m_Negative ? "-" : "") + this.m_Degree + "\u1d52 " + this.m_Minute + "' " + this.m_Second + "\" (" + this.toDecimal() + ")";
    }
}

