/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.data.gps.AbstractGPS;
import adams.data.gps.Coordinate;
import adams.data.gps.GPSDecimalDegrees;
import java.util.Vector;

public class GPSBoundary {
    protected AbstractGPS m_NE;
    protected AbstractGPS m_SW;

    public GPSBoundary(AbstractGPS NE, AbstractGPS SW) {
        this.m_NE = NE;
        this.m_SW = SW;
    }

    public AbstractGPS getNE() {
        return this.m_NE;
    }

    public AbstractGPS getSW() {
        return this.m_SW;
    }

    public AbstractGPS getCentre() {
        double minlat = this.m_NE.getLatitude().toDecimal();
        double maxlng = this.m_NE.getLongitude().toDecimal();
        double maxlat = this.m_SW.getLatitude().toDecimal();
        double minlng = this.m_SW.getLongitude().toDecimal();
        double ctrlat = (minlat + maxlat) / 2.0;
        double ctrlng = (minlng + maxlng) / 2.0;
        GPSDecimalDegrees c = new GPSDecimalDegrees(new Coordinate(ctrlat), new Coordinate(ctrlng));
        return c;
    }

    public static GPSBoundary createGPSBoundary(Vector<AbstractGPS> v) {
        double N = Double.NaN;
        double S = Double.NaN;
        double W = Double.NaN;
        double E = Double.NaN;
        for (AbstractGPS gps : v) {
            double lat = gps.getLatitude().toDecimal();
            double lon = gps.getLongitude().toDecimal();
            if (Double.isNaN(N) || lat > N) {
                N = lat;
            }
            if (Double.isNaN(S) || lat < S) {
                S = lat;
            }
            if (Double.isNaN(W) || lon < W) {
                W = lon;
            }
            if (!Double.isNaN(E) && !(lon > E)) continue;
            E = lon;
        }
        return new GPSBoundary(new GPSDecimalDegrees(N, E), new GPSDecimalDegrees(S, W));
    }
}

