/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.data.gps.Coordinate;
import adams.data.gps.GPSDecimalDegrees;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class GPSDecimalDegreesTest
extends AdamsTestCase {
    public GPSDecimalDegreesTest(String name) {
        super(name);
    }

    protected void performFromStringTest(String s, double lat, double lon, boolean swapped) {
        GPSDecimalDegrees gpsAct = new GPSDecimalDegrees(s, swapped);
        GPSDecimalDegrees gpsRef = new GPSDecimalDegrees(new Coordinate(lat), new Coordinate(lon));
        GPSDecimalDegreesTest.assertEquals((String)"Latitude differs", (Object)gpsRef.getLatitude().toDecimal(), (Object)gpsAct.getLatitude().toDecimal());
        GPSDecimalDegreesTest.assertEquals((String)"Longitude differs", (Object)gpsRef.getLongitude().toDecimal(), (Object)gpsAct.getLongitude().toDecimal());
    }

    public void testFromString() {
        this.performFromStringTest("51.20523 W0.58551", 51.20523, 0.58551, false);
        this.performFromStringTest("-51.20523 0.58551", -51.20523, 0.58551, false);
        this.performFromStringTest("N51.20523 E0.58551", 51.20523, -0.58551, false);
        this.performFromStringTest("S51.20523 E0.58551", -51.20523, -0.58551, false);
        this.performFromStringTest("-51.20523 -0.58551", -51.20523, -0.58551, false);
        this.performFromStringTest("W0.58551 51.20523", 51.20523, 0.58551, true);
        this.performFromStringTest("0.58551 -51.20523", -51.20523, 0.58551, true);
        this.performFromStringTest("E0.58551 N51.20523", 51.20523, -0.58551, true);
        this.performFromStringTest("E0.58551 S51.20523", -51.20523, -0.58551, true);
        this.performFromStringTest("-0.58551 -51.20523", -51.20523, -0.58551, true);
    }

    protected void performToStringTest(double lat, double lon, String s) {
        GPSDecimalDegrees gps = new GPSDecimalDegrees(new Coordinate(lat), new Coordinate(lon));
        GPSDecimalDegreesTest.assertEquals((String)"String differs", (String)s, (String)gps.toString());
    }

    public void testToString() {
        this.performToStringTest(51.20523, 0.58551, "N51.20523 W0.58551");
        this.performToStringTest(51.20523, -0.58551, "N51.20523 E0.58551");
        this.performToStringTest(-51.20523, -0.58551, "S51.20523 E0.58551");
    }

    public static Test suite() {
        return new TestSuite(GPSDecimalDegreesTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        GPSDecimalDegreesTest.runTest((Test)GPSDecimalDegreesTest.suite());
    }
}

