/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.core.Utils;
import adams.data.gps.AbstractGPS;
import adams.data.gps.Coordinate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GPSDecimalSeconds
extends AbstractGPS {
    private static final long serialVersionUID = 1902709328711736523L;
    public static final String FORMAT = "([NnSs\\+-]?)\\s*(\\d+)\\s*(\\d+)\\s+(\\d+)\\.(\\d+)[\\s,]*([WwEe\\+-]?)\\s*(\\d+)\\s*(\\d+)\\s+(\\d+)\\.(\\d+)\\s*";
    public static final String FORMAT_SWAPPED = "([WwEe\\+-]?)\\s*(\\d+)\\s*(\\d+)\\s+(\\d+)\\.(\\d+)[\\s,]*([NnSs\\+-]?)\\s*(\\d+)\\s*(\\d+)\\s+(\\d+)\\.(\\d+)\\s*";

    public GPSDecimalSeconds() {
    }

    public GPSDecimalSeconds(String s) {
        super(s);
    }

    public GPSDecimalSeconds(String s, boolean swapped) {
        super(s, swapped);
    }

    public GPSDecimalSeconds(AbstractGPS gps) {
        super(gps);
    }

    public GPSDecimalSeconds(double lat, double lon) {
        super(lat, lon);
    }

    public GPSDecimalSeconds(Coordinate lat, Coordinate lon) {
        super(lat, lon);
    }

    @Override
    protected GPSDecimalSeconds clone() {
        return new GPSDecimalSeconds(this);
    }

    @Override
    protected Coordinate[] parse(String s, boolean swapped) {
        Coordinate[] result = null;
        s = this.preprocess(s);
        Pattern pattern = swapped ? Pattern.compile(FORMAT_SWAPPED) : Pattern.compile(FORMAT);
        Matcher matcher = pattern.matcher(s);
        double latsign = 1.0;
        double longsign = 1.0;
        if (matcher.matches()) {
            String slatsign = matcher.group(1);
            String slongsign = matcher.group(6);
            if (swapped) {
                if (slongsign.equalsIgnoreCase("S") || slongsign.equals("-")) {
                    longsign = -1.0;
                }
                if (slatsign.equalsIgnoreCase("E") || slatsign.equals("-")) {
                    latsign = -1.0;
                }
            } else {
                if (slatsign.equalsIgnoreCase("S") || slatsign.equals("-")) {
                    latsign = -1.0;
                }
                if (slongsign.equalsIgnoreCase("E") || slongsign.equals("-")) {
                    longsign = -1.0;
                }
            }
            int latdegrees = Integer.parseInt(matcher.group(2));
            int longdegrees = Integer.parseInt(matcher.group(7));
            int latminutes = Integer.parseInt(matcher.group(3));
            int longminutes = Integer.parseInt(matcher.group(8));
            double latseconds = Double.parseDouble(matcher.group(4) + "." + matcher.group(5));
            double longseconds = Double.parseDouble(matcher.group(9) + "." + matcher.group(10));
            double lat = ((double)latdegrees + (double)latminutes / 60.0 + latseconds / 3600.0) * latsign;
            double lon = ((double)longdegrees + (double)longminutes / 60.0 + longseconds / 3600.0) * longsign;
            result = swapped ? new Coordinate[]{new Coordinate(lon), new Coordinate(lat)} : new Coordinate[]{new Coordinate(lat), new Coordinate(lon)};
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.m_Latitude.isNegative()) {
            result.append("S");
        } else {
            result.append("N");
        }
        result.append(Integer.toString(Math.abs(this.m_Latitude.getDegree())));
        result.append(" ");
        result.append(Integer.toString(Math.abs(this.m_Latitude.getMinute())));
        result.append(" ");
        String str = Utils.doubleToString((double)Math.abs(this.m_Latitude.getSecond()), (int)6);
        result.append(str);
        if (str.indexOf(46) == -1) {
            result.append(".0");
        }
        result.append(" ");
        if (this.m_Longitude.isNegative()) {
            result.append("E");
        } else {
            result.append("W");
        }
        result.append(Integer.toString(Math.abs(this.m_Longitude.getDegree())));
        result.append(" ");
        result.append(Integer.toString(Math.abs(this.m_Longitude.getMinute())));
        result.append(" ");
        str = Utils.doubleToString((double)Math.abs(this.m_Longitude.getSecond()), (int)6);
        result.append(str);
        if (str.indexOf(46) == -1) {
            result.append(".0");
        }
        return result.toString();
    }
}

