/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.DOMToString;
import adams.data.conversion.SpreadSheetStringColumnToObject;
import adams.data.conversion.SpreadSheetToKML;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.AbstractObjectHandler;
import adams.data.spreadsheet.GPSDecimalDegrees;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.env.Environment;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetToKMLTest
extends AbstractConversionTestCase {
    public SpreadSheetToKMLTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("gps.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("gps.csv");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        SpreadSheet sheet = reader.read((File)new TmpFile("gps.csv"));
        GPSDecimalDegrees degrees = new GPSDecimalDegrees();
        SpreadSheetStringColumnToObject conv = new SpreadSheetStringColumnToObject();
        conv.setColumn(new SpreadSheetColumnIndex("gps"));
        conv.setHandler((AbstractObjectHandler)degrees);
        conv.setInput((Object)sheet);
        conv.convert();
        sheet = (SpreadSheet)conv.getOutput();
        conv.cleanUp();
        return new SpreadSheet[]{sheet, sheet};
    }

    protected String toString(Object data) {
        DOMToString conv = new DOMToString();
        conv.setInput(data);
        conv.convert();
        String result = (String)conv.getOutput();
        conv.cleanUp();
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        SpreadSheetToKML[] result = new SpreadSheetToKML[2];
        result[0] = new SpreadSheetToKML();
        result[0].setColumnGPS(new SpreadSheetColumnIndex("gps"));
        result[1] = new SpreadSheetToKML();
        result[1].setColumnGPS(new SpreadSheetColumnIndex("gps"));
        result[1].setColumnID(new SpreadSheetColumnIndex("id"));
        result[1].setColumnName(new SpreadSheetColumnIndex("name"));
        result[1].setColumnElevation(new SpreadSheetColumnIndex("elevation"));
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetToKMLTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetToKMLTest.runTest((Test)SpreadSheetToKMLTest.suite());
    }
}

