/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.data.gps.Coordinate;
import adams.data.gps.GPSDecimalSeconds;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class GPSDecimalSecondsTest
extends AdamsTestCase {
    public GPSDecimalSecondsTest(String name) {
        super(name);
    }

    protected void performFromStringTest(String s, double lat, double lon, boolean swapped) {
        GPSDecimalSeconds gpsAct = new GPSDecimalSeconds(s, swapped);
        GPSDecimalSeconds gpsRef = new GPSDecimalSeconds(new Coordinate(lat), new Coordinate(lon));
        GPSDecimalSecondsTest.assertEquals((String)"Latitude differs", (Object)gpsRef.getLatitude().toDecimal(), (Object)gpsAct.getLatitude().toDecimal());
        GPSDecimalSecondsTest.assertEquals((String)"Longitude differs", (Object)gpsRef.getLongitude().toDecimal(), (Object)gpsAct.getLongitude().toDecimal());
    }

    public void testFromString() {
        this.performFromStringTest("51 12 18.36 W0 35 7.8", 51.2051, 0.5855, false);
        this.performFromStringTest("51 12 18.36 E0 35 7.8", 51.2051, -0.5855, false);
        this.performFromStringTest("S51 12 18.36 E0 35 7.8", -51.2051, -0.5855, false);
        this.performFromStringTest("S51 12 18.36 W0 35 7.8", -51.2051, 0.5855, false);
        this.performFromStringTest("W0 35 7.8 51 12 18.36", 51.2051, 0.5855, true);
        this.performFromStringTest("E0 35 7.8 51 12 18.36", 51.2051, -0.5855, true);
        this.performFromStringTest("E0 35 7.8 S51 12 18.36", -51.2051, -0.5855, true);
        this.performFromStringTest("W0 35 7.8 S51 12 18.36", -51.2051, 0.5855, true);
    }

    protected void performToStringTest(double lat, double lon, String s) {
        GPSDecimalSeconds gps = new GPSDecimalSeconds(new Coordinate(lat), new Coordinate(lon));
        GPSDecimalSecondsTest.assertEquals((String)"String differs", (String)s, (String)gps.toString());
    }

    public void testToString() {
        this.performToStringTest(51.2051, 0.5855, "N51 12 18.36 W0 35 7.8");
        this.performToStringTest(51.2051, -0.5855, "N51 12 18.36 E0 35 7.8");
        this.performToStringTest(-51.2051, 0.5855, "S51 12 18.36 W0 35 7.8");
        this.performToStringTest(-51.2051, -0.5855, "S51 12 18.36 E0 35 7.8");
    }

    public static Test suite() {
        return new TestSuite(GPSDecimalSecondsTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        GPSDecimalSecondsTest.runTest((Test)GPSDecimalSecondsTest.suite());
    }
}

