/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.data.gps.AbstractGPS;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class GPSEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
MultiSelectionEditor,
InlineEditorSupport {
    protected JTextComponent m_TextCoordinates;

    protected static AbstractGPS valueOf(Class cls, String str) {
        AbstractGPS result;
        try {
            Constructor constr = cls.getConstructor(String.class);
            result = (AbstractGPS)constr.newInstance(str);
        }
        catch (Exception e) {
            try {
                result = (AbstractGPS)cls.newInstance();
            }
            catch (Exception ex) {
                System.err.println("Failed to instantiate " + cls.getName() + " as " + AbstractGPS.class.getName() + "!");
                ex.printStackTrace();
                result = null;
            }
        }
        return result;
    }

    public static String toString(AbstractOption option, Object object) {
        return object.toString();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return GPSEditor.valueOf(((AbstractArgumentOption)option).getBaseClass(), str);
    }

    public String toCustomStringRepresentation(Object obj) {
        return obj.toString();
    }

    public Object fromCustomStringRepresentation(String str) {
        return GPSEditor.valueOf(this.getValue().getClass(), str);
    }

    public String getJavaInitializationString() {
        return "new " + this.getValue().getClass().getName() + "(\"" + this.getValue().toString() + "\")";
    }

    protected void acceptInput() {
        String s = this.m_TextCoordinates.getText();
        if (this.isValid(s) && !this.isUnchanged(s)) {
            this.setValue(GPSEditor.valueOf(this.getValue().getClass(), s));
        }
        this.closeDialog(1);
    }

    protected void discardInput() {
        this.closeDialog(0);
    }

    protected boolean isValid(String s) {
        return ((AbstractGPS)this.getValue()).isValid(s);
    }

    protected boolean isUnchanged(String s) {
        return s.equals(this.getValue().toString());
    }

    protected JComponent createCustomEditor() {
        this.m_TextCoordinates = new BaseTextArea(1, 20);
        ((BaseTextArea)this.m_TextCoordinates).setLineWrap(true);
        this.m_TextCoordinates.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    GPSEditor.this.acceptInput();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    GPSEditor.this.discardInput();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        JPanel panelAll = new JPanel(new BorderLayout());
        JLabel label = new JLabel("Coordinates");
        label.setDisplayedMnemonic('C');
        label.setLabelFor(this.m_TextCoordinates);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(label);
        panelAll.add((Component)panel, "West");
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        panel.add((Component)new BaseScrollPane((Component)this.m_TextCoordinates), "Center");
        panelAll.add((Component)panel, "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPSEditor.this.acceptInput();
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPSEditor.this.discardInput();
            }
        });
        panelButtons.add(buttonClose);
        return panelAll;
    }

    protected void initForDisplay() {
        super.initForDisplay();
        if (!this.m_TextCoordinates.getText().equals("" + this.getValue())) {
            this.m_TextCoordinates.setText("" + this.getValue());
        }
        this.m_TextCoordinates.setCaretPosition(this.m_TextCoordinates.getText().length());
        this.m_TextCoordinates.grabFocus();
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        AbstractGPS gps = (AbstractGPS)this.getValue();
        String val = "No coordinates";
        if (gps != null) {
            val = gps.toString();
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    public Object[] getSelectedObjects(Container parent) {
        Object[] result;
        MultiLineValueDialog dialog = new MultiLineValueDialog();
        dialog.setInfoText("Enter the coordinates, one pair per line:");
        dialog.setLocationRelativeTo((Component)parent);
        dialog.setVisible(true);
        Class<?> cls = this.getValue().getClass();
        if (dialog.getOption() == 0) {
            Vector<String> lines = new Vector<String>(Arrays.asList(dialog.getContent().split("\n")));
            Utils.removeEmptyLines(lines);
            result = (Object[])Array.newInstance(cls, lines.size());
            for (int i = 0; i < lines.size(); ++i) {
                Array.set(result, i, GPSEditor.valueOf(cls, lines.get(i)));
            }
        } else {
            result = (Object[])Array.newInstance(cls, 0);
        }
        return result;
    }

    public boolean isInlineEditingAvailable() {
        return true;
    }

    public void setInlineValue(String value) {
        this.setValue(GPSEditor.valueOf(this.getValue().getClass(), value));
    }

    public String getInlineValue() {
        return this.getValue().toString();
    }

    public boolean isInlineValueValid(String value) {
        return this.isValid(value);
    }
}

