/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.input.ChunkedSpreadSheetReader;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ArcInfoASCIIGridReader
extends AbstractSpreadSheetReader
implements ChunkedSpreadSheetReader {
    private static final long serialVersionUID = 1925577691804114810L;
    public static final String KEY_NUMCOLS = "ncols";
    public static final String KEY_NUMROWS = "nrows";
    public static final String KEY_LEFT = "xllcorner";
    public static final String KEY_BOTTOM = "yllcorner";
    public static final String KEY_CELLSIZE = "cellsize";
    public static final String KEY_NODATAVALUE = "NODATA_value";
    protected boolean m_OutputGrid;
    protected int m_ChunkSize;
    protected List<String> m_Raw;
    protected HashMap<String, String> m_MetaData;
    protected int m_Header;
    protected int m_Offset;

    public String globalInfo() {
        return "Reads ASCII files in ESRI Grid format.\n\nFor more information see:\nhttps://en.wikipedia.org/wiki/Esri_grid";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-grid", "outputGrid", (Object)false);
        this.m_OptionManager.add("chunk-size", "chunkSize", (Object)-1, (Number)-1, null);
    }

    protected void reset() {
        super.reset();
        this.m_Raw = new ArrayList<String>();
        this.m_MetaData = new HashMap();
        this.m_Header = 0;
        this.m_Offset = 0;
    }

    public void setOutputGrid(boolean value) {
        this.m_OutputGrid = value;
        this.reset();
    }

    public boolean getOutputGrid() {
        return this.m_OutputGrid;
    }

    public String outputGridTipText() {
        return "If enabled, a spreadsheet is generated that represents the data in the file rather than one value per row with GPS coordinates.";
    }

    public void setChunkSize(int value) {
        this.m_ChunkSize = value;
        this.reset();
    }

    public int getChunkSize() {
        return this.m_ChunkSize;
    }

    public String chunkSizeTipText() {
        return "The size of the chunks (= number of rows) of spreadsheets to output if not in grid mode.";
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.FILE;
    }

    public String getFormatDescription() {
        return "Arc/Info ASCII Grid";
    }

    public String[] getFormatExtensions() {
        return new String[]{"*"};
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return null;
    }

    protected SpreadSheet readData() {
        int i;
        int cols = Integer.parseInt(this.m_MetaData.get(KEY_NUMCOLS));
        int rows = Integer.parseInt(this.m_MetaData.get(KEY_NUMROWS));
        double left = Double.parseDouble(this.m_MetaData.get(KEY_LEFT));
        double bottom = Double.parseDouble(this.m_MetaData.get(KEY_BOTTOM));
        double cellSize = Double.parseDouble(this.m_MetaData.get(KEY_CELLSIZE));
        String missing = null;
        if (this.m_MetaData.containsKey(KEY_NODATAVALUE)) {
            missing = this.m_MetaData.get(KEY_NODATAVALUE);
        }
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        if (this.m_OutputGrid) {
            for (i = 0; i < cols; ++i) {
                row.addCell("" + i).setContent("col" + (i + 1));
            }
        } else {
            row.addCell("lat").setContent("Lat");
            row.addCell("lon").setContent("Lon");
            row.addCell("val").setContent("Value");
        }
        Number[] values = new Number[cols];
        for (i = this.m_Header + this.m_Offset; i < this.m_Raw.size(); ++i) {
            int colIdx;
            String line = this.m_Raw.get(i).trim();
            String[] parts = line.split(" ");
            if (this.m_Stopped) break;
            for (colIdx = 0; colIdx < parts.length; ++colIdx) {
                values[colIdx] = missing != null && parts[colIdx].equals(missing) ? null : (Utils.isInteger((String)parts[colIdx]) ? (Number)Integer.parseInt(parts[colIdx]) : (Number)Double.parseDouble(parts[colIdx]));
            }
            if (this.m_OutputGrid) {
                row = result.addRow();
                for (colIdx = 0; colIdx < parts.length; ++colIdx) {
                    row.addCell("" + colIdx).setNative((Object)values[colIdx]);
                }
            } else {
                int rowIdx = rows - 1 - (i - this.m_Header);
                double lat = bottom + (double)rowIdx * cellSize;
                for (colIdx = 0; colIdx < parts.length; ++colIdx) {
                    double lon = left + (double)colIdx * cellSize;
                    row = result.addRow();
                    row.addCell("lat").setContent(Double.valueOf(lat));
                    row.addCell("lon").setContent(Double.valueOf(lon));
                    row.addCell("val").setNative((Object)values[colIdx]);
                }
            }
            if (this.m_OutputGrid || this.m_ChunkSize <= 0 || i != this.m_Header + this.m_Offset + this.m_ChunkSize - 1 && i != this.m_Raw.size() - 1) continue;
            this.m_Offset += this.m_ChunkSize;
            break;
        }
        if (this.m_Raw.size() - this.m_Header < this.m_ChunkSize) {
            this.m_Offset = this.m_Raw.size() - this.m_Header;
        }
        if (this.m_Stopped) {
            result = null;
        }
        return result;
    }

    protected SpreadSheet doRead(File file) {
        String line;
        this.m_Raw = FileUtils.loadFromFile((File)file, (String)this.m_Encoding.getValue());
        if (this.m_Raw == null) {
            this.setLastError("Failed to read data from: " + file);
            return null;
        }
        this.m_MetaData.clear();
        this.m_Header = 0;
        for (int i = 0; i < this.m_Raw.size() && (line = this.m_Raw.get(i)).matches("^[a-zA-Z].*"); ++i) {
            line = line.replaceAll("[ ][ ]*", " ");
            ++this.m_Header;
            String[] parts = line.split(" ");
            if (parts.length == 2) {
                this.m_MetaData.put(parts[0], parts[1]);
                continue;
            }
            this.getLogger().warning("Failed to parse meta-data: " + line);
        }
        if (!this.m_MetaData.containsKey(KEY_NUMCOLS)) {
            this.setLastError("Missing meta-data: ncols");
            return null;
        }
        if (!this.m_MetaData.containsKey(KEY_NUMROWS)) {
            this.setLastError("Missing meta-data: nrows");
            return null;
        }
        if (!this.m_MetaData.containsKey(KEY_LEFT)) {
            this.setLastError("Missing meta-data: xllcorner");
            return null;
        }
        if (!this.m_MetaData.containsKey(KEY_BOTTOM)) {
            this.setLastError("Missing meta-data: yllcorner");
            return null;
        }
        if (!this.m_MetaData.containsKey(KEY_CELLSIZE)) {
            this.setLastError("Missing meta-data: cellsize");
            return null;
        }
        this.m_Offset = 0;
        SpreadSheet result = this.readData();
        return result;
    }

    public boolean hasMoreChunks() {
        return !this.m_OutputGrid && this.m_ChunkSize > 0 && this.m_Offset < this.m_Raw.size() - this.m_Header - 1;
    }

    public SpreadSheet nextChunk() {
        return this.readData();
    }
}

