/*
 * Decompiled with CFR 0.152.
 */
package adams.data.gps;

import adams.data.filter.AbstractDerivative;
import adams.data.gps.AbstractGPS;
import adams.data.gps.Coordinate;
import adams.data.gps.GPSBoundary;
import adams.data.gps.GPSDecimalDegrees;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;

public class Map {
    protected GPSBoundary m_boundary;
    protected int m_googleZoom;
    protected int m_x_pixels = 640;
    protected int m_y_pixels = 400;
    protected int centre_x;
    protected int centre_y;
    protected int m_scale = 1;
    protected Image m_mapImage;
    protected MapType m_maptype = MapType.satellite;

    public int getWidth() {
        return this.m_x_pixels;
    }

    public int getHeight() {
        return this.m_y_pixels;
    }

    protected void setWidthHeight(int width, int height) {
        this.m_x_pixels = width;
        this.m_y_pixels = height;
    }

    protected void setMapType(MapType maptype) {
        this.m_maptype = maptype;
    }

    protected boolean generateMapImage() {
        try {
            String surl = "http://maps.googleapis.com/maps/api/staticmap?center=" + this.m_boundary.getCentre().getLatitude().toDecimal() + "," + this.m_boundary.getCentre().getLongitude().toDecimal() + "&zoom=" + this.m_googleZoom + "&size=" + this.m_x_pixels + "x" + this.m_y_pixels + "&maptype=" + this.m_maptype.toString() + "&sensor=true&scale=" + this.m_scale;
            URL url = new URL(surl);
            this.m_mapImage = ImageIO.read(url);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Map getMap(AbstractGPS centre, int zoomlevel, int width, int height, MapType maptype) {
        AbstractGPS ne = Map.displayToCoordinate(new AbstractDerivative.Point((double)width, 0.0), zoomlevel);
        AbstractGPS sw = Map.displayToCoordinate(new AbstractDerivative.Point(0.0, (double)height), zoomlevel);
        return Map.getMap(new GPSBoundary(ne, sw), width, height, maptype);
    }

    public static Map getMap(Vector<AbstractGPS> v, int width, int height, MapType maptype) {
        GPSBoundary boundary = GPSBoundary.createGPSBoundary(v);
        return Map.getMap(boundary, width, height, maptype);
    }

    public static Map getMap(GPSBoundary boundary, int width, int height, MapType maptype) {
        Map m = new Map();
        m.m_boundary = boundary;
        m.setWidthHeight(width, height);
        m.setZoom();
        m.setMapType(maptype);
        m.generateMapImage();
        return m;
    }

    public void setZoom() {
        int mapdisplay = Math.min(this.m_x_pixels, this.m_y_pixels);
        double interval = 0.0;
        double minlat = this.m_boundary.getNE().getLatitude().toDecimal();
        double maxlng = this.m_boundary.getNE().getLongitude().toDecimal();
        double maxlat = this.m_boundary.getSW().getLatitude().toDecimal();
        double minlng = this.m_boundary.getSW().getLongitude().toDecimal();
        double ctrlat = (minlat + maxlat) / 2.0;
        double ctrlng = (minlng + maxlng) / 2.0;
        if (maxlat - minlat > maxlng - minlng) {
            interval = (maxlat - minlat) / 2.0;
            minlng = ctrlng - interval;
            maxlng = ctrlng + interval;
        } else {
            interval = (maxlng - minlng) / 2.0;
            minlat = ctrlat - interval;
            maxlat = ctrlat + interval;
        }
        double dist = 6371.0 * Math.acos(Math.sin(minlat / 57.2958) * Math.sin(maxlat / 57.2958) + Math.cos(minlat / 57.2958) * Math.cos(maxlat / 57.2958) * Math.cos(maxlng / 57.2958 - minlng / 57.2958));
        int zoom = (int)Math.round(Math.floor(8.0 - Math.log(1.6446 * dist / Math.sqrt(2 * (mapdisplay * mapdisplay))) / Math.log(2.0)));
        this.m_googleZoom = zoom + 1;
    }

    public static AbstractGPS displayToCoordinate(AbstractDerivative.Point point, int zoom) {
        double longitude = point.getX() * (360.0 / (Math.pow(2.0, zoom) * 256.0)) - 180.0;
        double latitude = point.getY() * (2.0 / (Math.pow(2.0, zoom) * 256.0));
        latitude = 1.0 - latitude;
        latitude *= Math.PI;
        latitude = Map.rad_deg(Math.atan(Math.sinh(latitude)));
        GPSDecimalDegrees coord = new GPSDecimalDegrees(new Coordinate(latitude), new Coordinate(longitude));
        return coord;
    }

    protected static double rad_deg(double p) {
        return p * 57.29577951308232;
    }

    public AbstractDerivative.Point AbstractGPSToRawPixel(AbstractGPS gps) {
        double latitude = gps.getLatitude().toDecimal();
        double longitude = gps.getLongitude().toDecimal();
        double x = (longitude + 180.0) / 360.0;
        double sinLatitude = Math.sin(latitude * Math.PI / 180.0);
        double y = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
        int mapSize = 256 << this.m_googleZoom;
        double xp = x * (double)mapSize + 0.5;
        double yp = y * (double)mapSize + 0.5;
        return new AbstractDerivative.Point(xp, yp);
    }

    public AbstractDerivative.Point GPSToPixel(AbstractGPS gps, int imgX, int imgY) {
        AbstractDerivative.Point here = this.AbstractGPSToRawPixel(gps);
        AbstractDerivative.Point centre = this.AbstractGPSToRawPixel(this.m_boundary.getCentre());
        double cxdiff = here.getX() - centre.getX();
        double cydiff = here.getY() - centre.getY();
        return new AbstractDerivative.Point((double)this.m_x_pixels / 2.0 + cxdiff, (double)this.m_y_pixels / 2.0 + cydiff);
    }

    public void setBoundary(Vector<AbstractGPS> vgps) {
        this.m_boundary = GPSBoundary.createGPSBoundary(vgps);
    }

    public String generateGoogleURL() {
        return "http://maps.googleapis.com/maps/api/staticmap?center=" + this.m_boundary.getCentre().getLatitude().toDecimal() + "," + this.m_boundary.getCentre().getLongitude().toDecimal() + "&zoom=" + this.m_googleZoom + "&size=" + this.m_x_pixels + "x" + this.m_y_pixels + "&maptype=" + this.m_maptype.toString() + "&sensor=true&scale=" + this.m_scale;
    }

    public Image getMapImage() {
        return this.m_mapImage;
    }

    public BufferedImage getBufferedMapImage() {
        try {
            Image image = this.m_mapImage;
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage(image, null, null);
            return bufferedImage;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static enum MapType {
        terrain,
        roadmap,
        satellite,
        hybrid;

    }
}

