/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.gps.AbstractGPS;
import com.grum.geocalc.Coordinate;
import com.grum.geocalc.EarthCalc;
import com.grum.geocalc.Point;

public class GPSDistance
extends AbstractConversion {
    private static final long serialVersionUID = 4042881508585524573L;
    protected DistanceCalculationType m_Type;

    public String globalInfo() {
        return "Computes the distance in meters between two GPS points.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)DistanceCalculationType.SPHERICAL_LAW_OF_COSINES);
    }

    public void setType(DistanceCalculationType value) {
        this.m_Type = value;
        this.reset();
    }

    public DistanceCalculationType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of distance calculation to perform.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
    }

    public Class accepts() {
        return AbstractGPS[].class;
    }

    public Class generates() {
        return Double.class;
    }

    protected Object doConvert() throws Exception {
        AbstractGPS[] gps = (AbstractGPS[])this.m_Input;
        if (gps.length != 2) {
            throw new IllegalStateException("Requires two GPS points, received: " + gps.length);
        }
        Point point1 = Point.at((Coordinate)Coordinate.fromDegrees((double)gps[0].getLatitude().toDecimal()), (Coordinate)Coordinate.fromDegrees((double)gps[0].getLongitude().toDecimal()));
        Point point2 = Point.at((Coordinate)Coordinate.fromDegrees((double)gps[1].getLatitude().toDecimal()), (Coordinate)Coordinate.fromDegrees((double)gps[1].getLongitude().toDecimal()));
        switch (this.m_Type) {
            case SPHERICAL_LAW_OF_COSINES: {
                return EarthCalc.gcdDistance((Point)point1, (Point)point2);
            }
            case HARVESINE: {
                return EarthCalc.harvesineDistance((Point)point1, (Point)point2);
            }
            case VINCENTY: {
                return EarthCalc.vincentyDistance((Point)point1, (Point)point2);
            }
        }
        throw new IllegalStateException("Unhandled distance type: " + this.m_Type);
    }

    public static enum DistanceCalculationType {
        SPHERICAL_LAW_OF_COSINES,
        HARVESINE,
        VINCENTY;

    }
}

