/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.gps.AbstractGPS;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.env.Environment;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SpreadSheetToKML
extends AbstractConversion {
    private static final long serialVersionUID = 753192005036047919L;
    protected SpreadSheetColumnIndex m_ColumnGPS;
    protected SpreadSheetColumnIndex m_ColumnElevation;
    protected SpreadSheetColumnIndex m_ColumnID;
    protected SpreadSheetColumnIndex m_ColumnName;

    public String globalInfo() {
        return "Turns a spreadsheet into a KML (Keyhole Markup Language) XML data structure.\nFor more information see:\nhttp://en.wikipedia.org/wiki/Keyhole_Markup_Language";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column-gps", "columnGPS", (Object)new SpreadSheetColumnIndex("first"));
        this.m_OptionManager.add("column-elevation", "columnElevation", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("column-id", "columnID", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("column-name", "columnName", (Object)new SpreadSheetColumnIndex());
    }

    public void setColumnGPS(SpreadSheetColumnIndex value) {
        this.m_ColumnGPS = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumnGPS() {
        return this.m_ColumnGPS;
    }

    public String columnGPSTipText() {
        return "The column with the GPS coordinate objects.";
    }

    public void setColumnElevation(SpreadSheetColumnIndex value) {
        this.m_ColumnElevation = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumnElevation() {
        return this.m_ColumnElevation;
    }

    public String columnElevationTipText() {
        return "The column with the (optional) elevation for the PlaceMark nodes; uses 0 if empty.";
    }

    public void setColumnID(SpreadSheetColumnIndex value) {
        this.m_ColumnID = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumnID() {
        return this.m_ColumnID;
    }

    public String columnIDTipText() {
        return "The column with the (optional) ID for the PlaceMark nodes; uses 1-based row index if empty.";
    }

    public void setColumnName(SpreadSheetColumnIndex value) {
        this.m_ColumnName = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumnName() {
        return this.m_ColumnName;
    }

    public String columnNameTipText() {
        return "The column with the (optional) name for the PlaceMark nodes; uses 1-based row index if empty.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"columnGPS", (Object)this.m_ColumnGPS, (String)"gps: ");
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return Document.class;
    }

    protected Object doConvert() throws Exception {
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        this.m_ColumnGPS.setData((Object)sheet);
        this.m_ColumnElevation.setData((Object)sheet);
        this.m_ColumnID.setData((Object)sheet);
        this.m_ColumnName.setData((Object)sheet);
        int colGPS = this.m_ColumnGPS.getIntIndex();
        int colEl = this.m_ColumnElevation.getIntIndex();
        int colID = this.m_ColumnID.getIntIndex();
        int colName = this.m_ColumnName.getIntIndex();
        if (colGPS == -1) {
            throw new IllegalStateException("GPS column not found: " + this.m_ColumnGPS);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation domImpl = builder.getDOMImplementation();
        Document result = domImpl.createDocument("http://earth.google.com/kml/2.0", "kml", null);
        result.getDocumentElement().setAttribute("xmlns:atom", "http://www.w3.org/2005/Atom");
        Element root = result.createElement("Document");
        result.getDocumentElement().appendChild(root);
        Element child = result.createElement("name");
        child.setTextContent(sheet.getName());
        root.appendChild(child);
        child = result.createElement("atom:author");
        root.appendChild(child);
        Element cchild = result.createElement("atom:name");
        cchild.setTextContent(Environment.getInstance().getProject());
        child.appendChild(cchild);
        Element folder = result.createElement("Folder");
        root.appendChild(folder);
        child = result.createElement("name");
        child.setTextContent("default");
        folder.appendChild(child);
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            DataRow row = sheet.getRow(i);
            Element plmark = result.createElement("Placemark");
            folder.appendChild(plmark);
            if (colID == -1) {
                plmark.setAttribute("id", "" + (i + 1));
            } else {
                plmark.setAttribute("id", row.getCell(colID).getContent());
            }
            child = result.createElement("name");
            plmark.appendChild(child);
            if (colName == -1) {
                child.setTextContent("" + (i + 1));
            } else {
                child.setTextContent(row.getCell(colName).getContent());
            }
            AbstractGPS gps = (AbstractGPS)row.getCell(colGPS).getObject();
            double elevation = colEl == -1 ? 0.0 : row.getCell(colEl).toDouble();
            child = result.createElement("Point");
            plmark.appendChild(child);
            cchild = result.createElement("coordinates");
            cchild.setTextContent(gps.getLongitude().toDecimal() + "," + gps.getLatitude().toDecimal() + "," + elevation);
            child.appendChild(cchild);
        }
        return result;
    }
}

