/*
 * Decompiled with CFR 0.152.
 */
package adams.data.utils;

import adams.core.License;
import adams.core.TechnicalInformation;
import adams.core.annotation.MixedCopyright;
import org.jtransforms.fft.DoubleFFT_1D;

@MixedCopyright(author="Gene - http://stackoverflow.com/users/1161878/gene", license=License.CC_BY_SA_3, url="http://stackoverflow.com/a/12453487/4698227")
public class AutoCorrelation {
    public static double[] bruteForce(double[] x) {
        if (x.length % 2 != 0) {
            throw new IllegalStateException("Signal array must be of even length, provided: " + x.length);
        }
        int n = x.length;
        double[] result = new double[n];
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < n; ++i) {
                int n2 = j;
                result[n2] = result[n2] + x[i] * x[(n + i - j) % n];
            }
        }
        return result;
    }

    private static double sqr(double x) {
        return x * x;
    }

    public static double[] fft(double[] x, boolean normalize) {
        int i;
        if (x.length % 2 != 0) {
            throw new IllegalStateException("Signal array must be of even length, provided: " + x.length);
        }
        int n = x.length;
        double[] result = new double[n];
        DoubleFFT_1D fft = new DoubleFFT_1D((long)n);
        fft.realForward(x);
        result[0] = AutoCorrelation.sqr(x[0]);
        if (normalize) {
            result[0] = 0.0;
        }
        result[1] = AutoCorrelation.sqr(x[1]);
        for (i = 2; i < n; i += 2) {
            result[i] = AutoCorrelation.sqr(x[i]) + AutoCorrelation.sqr(x[i + 1]);
            result[i + 1] = 0.0;
        }
        DoubleFFT_1D ifft = new DoubleFFT_1D((long)n);
        ifft.realInverse(result, true);
        if (normalize) {
            i = 1;
            while (i < n) {
                int n2 = i++;
                result[n2] = result[n2] / result[0];
            }
            result[0] = 1.0;
        }
        return result;
    }

    public static TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "WikiPedia");
        result.setValue(TechnicalInformation.Field.TITLE, "Autocorrelation");
        result.setValue(TechnicalInformation.Field.HTTP, "https://en.wikipedia.org/wiki/Autocorrelation");
        return result;
    }
}

