/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.sequence.XYSequencePoint;
import adams.data.utils.LOWESS;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AbstractStrokePaintlet;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import adams.gui.visualization.sequence.XYSequencePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class LOWESSOverlayPaintlet
extends AbstractStrokePaintlet
implements XYSequencePaintlet,
AntiAliasingSupporter,
TechnicalInformationHandler {
    private static final long serialVersionUID = 6292059403058224856L;
    protected Color m_Color;
    protected int m_Window;
    protected boolean m_AntiAliasingEnabled;

    public String globalInfo() {
        return "Overlay that applies LOWESS smoothing over all the data points in the plot(s).\n\nFor more information see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        return LOWESS.getTechnicalInformation();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", (Object)Color.BLACK);
        this.m_OptionManager.add("window", "window", (Object)20, (Number)1, null);
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.memberChanged();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color for the line.";
    }

    public void setWindow(int value) {
        if (value >= 1) {
            this.m_Window = value;
            this.memberChanged();
        } else {
            this.getLogger().warning("Window size must >= 1, provided: " + value);
        }
    }

    public int getWindow() {
        return this.m_Window;
    }

    public String windowTipText() {
        return "The window size to use.";
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.GRID;
    }

    public XYSequencePanel getSequencePanel() {
        return (XYSequencePanel)this.getPanel();
    }

    public AbstractXYSequencePointHitDetector newHitDetector() {
        return null;
    }

    protected void doPerformPaint(Graphics g, PaintEvent.PaintMoment moment) {
        int i;
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (i = 0; i < ((XYSequenceContainerManager)this.getSequencePanel().getContainerManager()).countVisible(); ++i) {
            XYSequenceContainer cont = ((XYSequenceContainerManager)this.getSequencePanel().getContainerManager()).getVisible(i);
            for (XYSequencePoint p : cont.getData()) {
                points.add(new Point2D.Double(p.getX(), p.getY()));
            }
        }
        List<Point2D> smoothed = LOWESS.calculate(points, this.m_Window);
        g.setColor(this.m_Color);
        GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
        AxisPanel xAxis = this.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel yAxis = this.getPlot().getAxis(Axis.LEFT);
        for (i = 1; i < smoothed.size(); ++i) {
            Point2D prior = smoothed.get(i - 1);
            Point2D current = smoothed.get(i);
            g.drawLine(xAxis.valueToPos(prior.getX()), yAxis.valueToPos(prior.getY()), xAxis.valueToPos(current.getX()), yAxis.valueToPos(current.getY()));
        }
    }
}

