/*
 * Decompiled with CFR 0.152.
 */
package edu.umbc.cs.maple.utils;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import edu.umbc.cs.maple.utils.JamaUtils;

public class SGTUtils {
    public static Matrix weightedAdjacencyToLaplacian(Matrix adjacencyMatrix, LaplacianType laplacianType) {
        if (JamaUtils.isSymmetric(adjacencyMatrix)) {
            return SGTUtils.undirectedWeightedAdjacencyToLaplacian(adjacencyMatrix, laplacianType);
        }
        return SGTUtils.directedWeightedAdjacencyToLaplacian(adjacencyMatrix, laplacianType);
    }

    public static Matrix undirectedWeightedAdjacencyToLaplacian(Matrix adjacencyMatrix, LaplacianType laplacianType) {
        int numCols;
        int numRows = adjacencyMatrix.getRowDimension();
        if (numRows != (numCols = adjacencyMatrix.getColumnDimension())) {
            throw new IllegalArgumentException("adjacencyMatrix must be square.");
        }
        double[] colsums = new double[numCols];
        for (int i = 0; i < numCols; ++i) {
            colsums[i] = JamaUtils.colsum(adjacencyMatrix, i);
        }
        Matrix Laplacian = new Matrix(numRows, numCols);
        switch (laplacianType) {
            case NORMALIZED: {
                for (int u = 0; u < numRows; ++u) {
                    double du = colsums[u];
                    for (int v = 0; v < numRows; ++v) {
                        double dv = colsums[v];
                        double lapUV = u == v && dv != 0.0 ? 1.0 - adjacencyMatrix.get(v, v) / dv : (adjacencyMatrix.get(u, v) > 0.0 ? -adjacencyMatrix.get(u, v) / Math.sqrt(du * dv) : 0.0);
                        Laplacian.set(u, v, lapUV);
                    }
                }
                break;
            }
            case COMBINATORIAL: {
                for (int u = 0; u < numRows; ++u) {
                    for (int v = 0; v < numRows; ++v) {
                        double dv = colsums[v];
                        double lapUV = u == v ? dv - adjacencyMatrix.get(v, v) : (adjacencyMatrix.get(u, v) > 0.0 ? -adjacencyMatrix.get(u, v) : 0.0);
                        Laplacian.set(u, v, lapUV);
                    }
                }
                break;
            }
        }
        return Laplacian;
    }

    public static Matrix directedWeightedAdjacencyToLaplacian(Matrix adjacencyMatrix, LaplacianType laplacianType) {
        int numCols;
        int numRows = adjacencyMatrix.getRowDimension();
        if (numRows != (numCols = adjacencyMatrix.getColumnDimension())) {
            throw new IllegalArgumentException("adjacencyMatrix must be square.");
        }
        double[] rowsums = new double[numRows];
        for (int i = 0; i < numRows; ++i) {
            rowsums[i] = JamaUtils.rowsum(adjacencyMatrix, i);
        }
        Matrix P = new Matrix(numRows, numCols);
        double defaultTransitionProbability = 1.0 / (double)(numRows - 1);
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                double value = rowsums[i] == 0.0 ? (i == j ? 0.0 : defaultTransitionProbability) : adjacencyMatrix.get(i, j) / rowsums[i];
                P.set(i, j, value);
            }
        }
        double eta = 0.99;
        Matrix Pteleport = P.times(eta).plus(JamaUtils.ones(numRows, numRows).times((1.0 - eta) / (double)numRows));
        Matrix psi = Matrix.random((int)numRows, (int)1);
        psi = JamaUtils.normalize(psi);
        boolean converged = false;
        int numIterations = 0;
        while (!converged) {
            Matrix psi_new = psi.transpose().times(Pteleport).transpose();
            double norm = psi.minus(psi_new = JamaUtils.normalize(psi_new)).normF();
            if (norm < 1.0E-8) {
                converged = true;
            }
            psi = psi_new;
            if (++numIterations <= 500) continue;
            converged = true;
            System.err.println("Power method exceeded maximum number of iterations.  Results may be inaccurate.  Current norm:  " + norm);
        }
        Matrix phi = new Matrix(numRows, numCols);
        for (int i = 0; i < numRows; ++i) {
            phi.set(i, i, psi.get(i, 0));
        }
        Matrix PconjugateTranspose = P.transpose();
        Matrix Laplacian = null;
        switch (laplacianType) {
            case NORMALIZED: {
                Matrix phiSquareRoot = new Matrix(numRows, numCols);
                Matrix phiNegSquareRoot = new Matrix(numRows, numCols);
                for (int i = 0; i < numRows; ++i) {
                    double value = phi.get(i, i);
                    phiSquareRoot.set(i, i, Math.sqrt(value));
                    phiNegSquareRoot.set(i, i, Math.pow(value, -0.5));
                }
                Matrix temp1 = phiSquareRoot.times(P.times(phiNegSquareRoot));
                Matrix temp2 = phiNegSquareRoot.times(PconjugateTranspose.times(phiSquareRoot));
                Matrix temp3 = temp1.plus(temp2).times(0.5);
                Laplacian = Matrix.identity((int)numRows, (int)numCols).minus(temp3);
                break;
            }
            case COMBINATORIAL: {
                Matrix tempA = phi.times(P);
                Matrix tempB = PconjugateTranspose.times(phi);
                Matrix tempC = tempA.plus(tempB).times(0.5);
                Laplacian = phi.minus(tempC);
            }
        }
        return Laplacian;
    }

    public static Matrix[] resolution(Matrix A, int resolution, KeyEigenvalues keyEigenvalues) {
        EigenvalueDecomposition eig = A.eig();
        Matrix Q = eig.getV();
        Matrix L = eig.getD();
        int n = Q.getColumnDimension();
        Matrix Lk = null;
        Matrix Qk = null;
        if (resolution > n) {
            throw new IllegalArgumentException("Max resolution available is: " + n + ".");
        }
        switch (keyEigenvalues) {
            case SMALLEST: {
                for (int i = resolution; i < n; ++i) {
                    for (int j = resolution; j < n; ++j) {
                        L.set(i, j, 0.0);
                    }
                }
                Lk = L.getMatrix(0, resolution - 1, 0, resolution - 1);
                Qk = Q.getMatrix(0, n - 1, 0, resolution - 1);
                break;
            }
            case LARGEST: {
                int stop = n - resolution;
                for (int i = 0; i < stop; ++i) {
                    for (int j = 0; j < stop; ++j) {
                        L.set(i, j, 0.0);
                    }
                }
                Lk = L.getMatrix(stop, n - 1, stop, n - 1);
                Qk = Q.getMatrix(0, n - 1, stop, n - 1);
            }
        }
        Matrix Ak = Q.times(L).times(Q.transpose());
        Matrix[] struct = new Matrix[]{Ak, Qk, Lk};
        return struct;
    }

    public static Matrix[] resolutionGraphFunction(Matrix graphLaplacian, Matrix f, int resolution) {
        Matrix[] eigLaplacian = SGTUtils.resolution(graphLaplacian, resolution, KeyEigenvalues.SMALLEST);
        Matrix Qk = eigLaplacian[1];
        Matrix Lk = eigLaplacian[2];
        Matrix fk = SGTUtils.projectFunctionToBasis(Qk, f);
        Matrix[] struct = new Matrix[]{fk, Qk, Lk};
        return struct;
    }

    public static Matrix projectFunctionToBasis(Matrix basisVectors, Matrix f) {
        Matrix Qk = basisVectors;
        int numrowsf = f.getRowDimension();
        int numcolsf = f.getColumnDimension();
        int numcolsQk = Qk.getColumnDimension();
        Matrix fk = new Matrix(numrowsf, numcolsf);
        for (int col = 0; col < numcolsf; ++col) {
            Matrix f_col = JamaUtils.getcol(f, col);
            for (int i = 0; i < numcolsQk; ++i) {
                Matrix qi = JamaUtils.getcol(Qk, i);
                Matrix temp = JamaUtils.getcol(fk, col).plus(qi.times(JamaUtils.dotproduct(f_col, qi)));
                JamaUtils.setcol(fk, col, temp);
            }
        }
        return fk;
    }

    public static enum KeyEigenvalues {
        LARGEST,
        SMALLEST;

    }

    public static enum LaplacianType {
        COMBINATORIAL,
        NORMALIZED;

    }
}

