/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control.plotprocessor;

import adams.core.QuickInfoHelper;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.option.OptionHandler;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.control.plotprocessor.AbstractPlotProcessor;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class SimpleSavitzkyGolay
extends AbstractPlotProcessor
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 5171916489269022308L;
    protected int m_WindowSize;
    protected List<Point2D> m_Data;

    public String globalInfo() {
        return "A processor that applies SimpleSavitzkyGolay smoothing.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    protected void initialize() {
        super.initialize();
        this.m_Data = new ArrayList<Point2D>();
    }

    protected void reset() {
        super.reset();
        this.m_Data.clear();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "A. Savitzky and Marcel J.E. Golay");
        result.setValue(TechnicalInformation.Field.TITLE, "Smoothing and Differentiation of Data by Simplified Least Squares Procedures");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Analytical Chemistry");
        result.setValue(TechnicalInformation.Field.VOLUME, "36");
        result.setValue(TechnicalInformation.Field.PAGES, "1627-1639");
        result.setValue(TechnicalInformation.Field.YEAR, "1964");
        result.setValue(TechnicalInformation.Field.HTTP, "http://dx.doi.org/10.1021/ac60214a047");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("window-size", "windowSize", (Object)7, (Number)3, null);
    }

    public void setWindowSize(int value) {
        if (value == -1 || value >= 3 && value % 2 == 1) {
            this.m_WindowSize = value;
            this.reset();
        } else {
            this.getLogger().severe("The window size must be at least 3 and an odd number or -1 if no optimization is to be used (provided: " + value + ")!");
        }
    }

    public int getWindowSize() {
        return this.m_WindowSize;
    }

    public String windowSizeTipText() {
        return "The window size to use, must be at least 20.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"windowSize", (Object)this.m_WindowSize, (String)", window: ");
        return result;
    }

    protected List<SequencePlotterContainer> doProcess(SequencePlotterContainer cont) {
        ArrayList<SequencePlotterContainer> result = null;
        Comparable x = (Comparable)cont.getValue("X");
        Comparable y = (Comparable)cont.getValue("Y");
        if (x instanceof Number && y instanceof Number) {
            Point2D.Double point = new Point2D.Double(((Number)((Object)x)).doubleValue(), ((Number)((Object)y)).doubleValue());
            this.m_Data.add(point);
            while (this.m_Data.size() > this.m_WindowSize) {
                this.m_Data.remove(0);
            }
            if (this.m_Data.size() == this.m_WindowSize) {
                int winOff;
                result = new ArrayList<SequencePlotterContainer>();
                for (int i = winOff = (this.m_WindowSize - 1) / 2; i < this.m_Data.size() - winOff; ++i) {
                    double val = 0.0;
                    for (int j = -winOff; j <= winOff; ++j) {
                        val += (double)j * this.m_Data.get(i + j).getY();
                    }
                    result.add(new SequencePlotterContainer(this.getPlotName(cont), (Comparable)Double.valueOf(this.m_Data.get(i - winOff).getX()), (Comparable)Double.valueOf(val), this.getPlotType()));
                }
            }
        }
        return result;
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_Data.clear();
    }
}

