/*
 * Decompiled with CFR 0.152.
 */
package adams.data.autocorrelation;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.autocorrelation.AbstractAutoCorrelation;
import adams.test.AbstractDatabaseTestCase;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractAutoCorrelationTestCase
extends AbstractDatabaseTestCase {
    public AbstractAutoCorrelationTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/autocorrelation/data");
    }

    protected double[] process(double[] data, AbstractAutoCorrelation scheme) {
        return scheme.correlate(data);
    }

    protected String toString(double[] data) {
        return Utils.arrayToString((Object)data);
    }

    protected boolean save(Object data, String filename) {
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)data.toString(), (boolean)false);
    }

    protected abstract double[][] getRegressionData();

    protected abstract AbstractAutoCorrelation[] getRegressionSetups();

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    protected String createOutputFilename(int no) {
        return "out-" + no + ".txt";
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        double[][] data = this.getRegressionData();
        AbstractAutoCorrelation[] setups = this.getRegressionSetups();
        String[] output = new String[setups.length];
        int[] ignored = this.getRegressionIgnoredLineIndices();
        AbstractAutoCorrelationTestCase.assertEquals((String)"Number of data and setups differ!", (int)data.length, (int)setups.length);
        for (int n = 0; n < setups.length; ++n) {
            output[n] = this.createOutputFilename(n);
            AbstractAutoCorrelation current = (AbstractAutoCorrelation)OptionUtils.shallowCopy((OptionHandler)setups[n], (boolean)false);
            AbstractAutoCorrelationTestCase.assertNotNull((String)("Failed to create copy of autocorrelation algorithm: " + OptionUtils.getCommandLine((Object)setups[n])), (Object)current);
            double[] processed = this.process(data[n], current);
            AbstractAutoCorrelationTestCase.assertNotNull((String)("Failed to process data: " + Utils.arrayToString((Object)data[n])), (Object)processed);
            boolean ok = this.save(this.toString(processed), output[n]);
            AbstractAutoCorrelationTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles, ignored);
        AbstractAutoCorrelationTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

