/*
 * Decompiled with CFR 0.152.
 */
package adams.data.baseline;

import adams.core.TechnicalInformation;
import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractLOWESS;

public abstract class AbstractLOWESSBased<T extends DataContainer>
extends AbstractBaselineCorrection<T> {
    private static final long serialVersionUID = 1662223546956780389L;
    protected AbstractLOWESS m_Filter;

    public String globalInfo() {
        return "A baseline correction scheme that uses LOWESS smoothing to determine the baseline.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        return this.getFilter().getTechnicalInformation();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("window-size", "windowSize", (Object)20, (Number)1, null);
    }

    protected void initialize() {
        super.initialize();
        this.m_Filter = this.getFilter();
    }

    protected abstract AbstractLOWESS getFilter();

    public void setWindowSize(int value) {
        this.m_Filter.setWindowSize(value);
    }

    public int getWindowSize() {
        return this.m_Filter.getWindowSize();
    }

    public String windowSizeTipText() {
        return this.m_Filter.windowSizeTipText();
    }

    protected abstract DataPoint subtract(DataPoint var1, DataPoint var2);

    protected T processData(T data) {
        DataContainer filtered = this.m_Filter.filter((DataContainer)data);
        DataContainer result = data.getHeader();
        for (int i = 0; i < data.size(); ++i) {
            DataPoint oldPoint = (DataPoint)data.toList().get(i);
            DataPoint newPoint = this.subtract(oldPoint, (DataPoint)filtered.toList().get(i));
            result.add((Object)newPoint);
        }
        return (T)result;
    }
}

