/*
 * Decompiled with CFR 0.152.
 */
package adams.data.binning.algorithm;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.binning.Bin;
import adams.data.binning.Binnable;
import adams.data.binning.algorithm.AbstractEqualWidthBinningAlgorithm;
import edu.umbc.cs.maple.utils.MathUtils;
import java.util.List;

public class SturgesFormulaBinning
extends AbstractEqualWidthBinningAlgorithm
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -1486327441961729111L;

    public String globalInfo() {
        return "Sturges' formula is derived from a binomial distribution and implicitly assumes an approximately normal distribution.\n\nFor more information see:\n" + this.getTechnicalInformation();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.YEAR, "2010");
        result.setValue(TechnicalInformation.Field.AUTHOR, "WikiPedia");
        result.setValue(TechnicalInformation.Field.TITLE, "Histogram");
        result.setValue(TechnicalInformation.Field.HTTP, "http://en.wikipedia.org/wiki/Histogram");
        return result;
    }

    protected <T> List<Bin<T>> doGenerateBins(List<Binnable<T>> objects) {
        return this.doGenerateBins(objects, (int)Math.ceil(MathUtils.log2(objects.size())) + 1);
    }
}

