/*
 * Decompiled with CFR 0.152.
 */
package adams.data.distribution;

import adams.data.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;

public class Uniform
extends AbstractRealDistribution {
    private static final long serialVersionUID = -1708992443868275973L;
    protected double m_LowerBound;
    protected double m_UpperBound;

    public String globalInfo() {
        return "The Uniform distribution.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("lower-bound", "lowerBound", (Object)0.0);
        this.m_OptionManager.add("upper-bound", "upperBound", (Object)1.0);
    }

    public void setLowerBound(double value) {
        this.m_LowerBound = value;
        this.reset();
    }

    public double getLowerBound() {
        return this.m_LowerBound;
    }

    public String meanTipText() {
        return "The lower bound.";
    }

    public void setUpperBound(double value) {
        this.m_UpperBound = value;
        this.reset();
    }

    public double getUpperBound() {
        return this.m_UpperBound;
    }

    public String upperBoundTipText() {
        return "The upper bound.";
    }

    public RealDistribution getRealDistribution() {
        return new UniformRealDistribution(this.m_LowerBound, this.m_UpperBound);
    }
}

