/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import JSci.maths.Complex;
import JSci.maths.FourierMath;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.padding.PaddingHelper;
import adams.data.padding.PaddingType;
import java.util.List;

public abstract class AbstractFFT<T extends DataContainer>
extends AbstractFilter<T>
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 8562484608944330752L;
    protected PaddingType m_PaddingType;
    protected boolean m_InverseTransform;
    protected boolean m_Real;

    public String globalInfo() {
        return "A filter that transforms the data with Fast Fourier Transform.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Mark Hale");
        result.setValue(TechnicalInformation.Field.YEAR, "2009");
        result.setValue(TechnicalInformation.Field.TITLE, "JSci - A science API for Java");
        result.setValue(TechnicalInformation.Field.HTTP, "http://jsci.sourceforge.net/");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("padding", "paddingType", (Object)PaddingType.ZERO);
        this.m_OptionManager.add("inverse", "inverseTransform", (Object)false);
        this.m_OptionManager.add("real", "real", (Object)true);
    }

    public void setPaddingType(PaddingType value) {
        this.m_PaddingType = value;
        this.reset();
    }

    public PaddingType getPaddingType() {
        return this.m_PaddingType;
    }

    public String paddingTypeTipText() {
        return "The padding type to use.";
    }

    public void setInverseTransform(boolean value) {
        this.m_InverseTransform = value;
        this.reset();
    }

    public boolean getInverseTransform() {
        return this.m_InverseTransform;
    }

    public String inverseTransformTipText() {
        return "If true, then the inverse transform is performed.";
    }

    public void setReal(boolean value) {
        this.m_Real = value;
        this.reset();
    }

    public boolean getReal() {
        return this.m_Real;
    }

    public String realTipText() {
        return "If enabled, the real part of the tranformation is returned.";
    }

    protected abstract double getValue(DataPoint var1);

    protected abstract DataPoint newDataPoint(List<DataPoint> var1, int var2, double var3);

    protected T processData(T data) {
        int i;
        DataContainer result = data.getHeader();
        List points = data.toList();
        double[] real = new double[data.size()];
        for (i = 0; i < data.size(); ++i) {
            real[i] = this.getValue((DataPoint)points.get(i));
        }
        real = PaddingHelper.padPow2((double[])real, (PaddingType)this.m_PaddingType);
        Complex[] transformed = this.m_InverseTransform ? FourierMath.inverseTransform((double[])real) : FourierMath.transform((double[])real);
        for (i = 0; i < transformed.length; ++i) {
            double value = this.m_Real ? transformed[i].real() : transformed[i].imag();
            DataPoint newPoint = this.newDataPoint(points, i, value);
            result.add((Object)newPoint);
        }
        return (T)result;
    }
}

