/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.utils.LOWESS;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractLOWESS<T extends DataContainer>
extends AbstractFilter<T>
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 7714239052976065971L;
    protected int m_WindowSize;

    public String globalInfo() {
        return "A filter that applies LOWESS smoothing.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        return LOWESS.getTechnicalInformation();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("window-size", "windowSize", (Object)20, (Number)1, null);
    }

    public void setWindowSize(int value) {
        if (value >= 1) {
            this.m_WindowSize = value;
            this.reset();
        } else {
            this.getLogger().severe("The window size must be at least 1 (provided: " + value + ")!");
        }
    }

    public int getWindowSize() {
        return this.m_WindowSize;
    }

    public String windowSizeTipText() {
        return "The window size to use, must be at least 1.";
    }

    protected abstract Point2D convert(DataPoint var1);

    protected abstract DataPoint newDataPoint(Point2D var1);

    protected T processData(T data) {
        int i;
        ArrayList<Point2D> raw = new ArrayList<Point2D>();
        for (i = 0; i < data.size(); ++i) {
            raw.add(this.convert((DataPoint)data.toList().get(i)));
        }
        List<Point2D> smoothed = LOWESS.calculate(raw, this.m_WindowSize);
        DataContainer result = data.getHeader();
        for (i = 0; i < smoothed.size(); ++i) {
            result.add((Object)this.newDataPoint(smoothed.get(i)));
        }
        return (T)result;
    }
}

