/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.NotesHandler;
import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.utils.SavitzkyGolay;
import java.util.List;

public abstract class AbstractSavitzkyGolay<T extends DataContainer>
extends AbstractFilter<T>
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 7714239052976065971L;
    protected int m_PolynomialOrder;
    protected int m_DerivativeOrder;
    protected int m_NumPointsLeft;
    protected int m_NumPointsRight;
    protected double[] m_Coefficients;

    public String globalInfo() {
        return "A filter that applies Savitzky-Golay smoothing.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        return SavitzkyGolay.getTechnicalInformation();
    }

    protected void initialize() {
        super.initialize();
        this.m_Coefficients = null;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("polynomial", "polynomialOrder", (Object)2, (Number)2, null);
        this.m_OptionManager.add("derivative", "derivativeOrder", (Object)1, (Number)0, null);
        this.m_OptionManager.add("left", "numPointsLeft", (Object)3, (Number)0, null);
        this.m_OptionManager.add("right", "numPointsRight", (Object)3, (Number)0, null);
    }

    public void resetCoefficients() {
        this.m_Coefficients = null;
    }

    public void setPolynomialOrder(int value) {
        if (value >= 2) {
            this.m_PolynomialOrder = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getLogger().severe("The polynomial order must be at least 2 (provided: " + value + ")!");
        }
    }

    public int getPolynomialOrder() {
        return this.m_PolynomialOrder;
    }

    public String polynomialOrderTipText() {
        return "The polynomial order to use, must be at least 2.";
    }

    public void setDerivativeOrder(int value) {
        if (value >= 0) {
            this.m_DerivativeOrder = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getLogger().severe("The order of the derivative must be at least 0 (provided: " + value + ")!");
        }
    }

    public int getDerivativeOrder() {
        return this.m_DerivativeOrder;
    }

    public String derivativeOrderTipText() {
        return "The order of the derivative to use, >= 0.";
    }

    public void setNumPointsLeft(int value) {
        if (value >= 0) {
            this.m_NumPointsLeft = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getLogger().severe("The number of points to the left must be at least 0 (provided: " + value + ")!");
        }
    }

    public int getNumPointsLeft() {
        return this.m_NumPointsLeft;
    }

    public String numPointsLeftTipText() {
        return "The number of points left of a data point, >= 0.";
    }

    public void setNumPointsRight(int value) {
        if (value >= 0) {
            this.m_NumPointsRight = value;
            this.reset();
            this.resetCoefficients();
        } else {
            this.getLogger().severe("The number of points to the right must be at least 0 (provided: " + value + ")!");
        }
    }

    public int getNumPointsRight() {
        return this.m_NumPointsRight;
    }

    public String numPointsRightTipText() {
        return "The number of points right of a data point, >= 0.";
    }

    protected abstract double getValue(DataPoint var1);

    protected abstract DataPoint newDataPoint(DataPoint var1, double var2);

    protected void postProcess(DataPoint oldPoint, DataPoint newPoint) {
    }

    protected T processData(T data) {
        if (this.m_Coefficients == null) {
            if (data.size() < this.m_NumPointsLeft + this.m_NumPointsRight + 1) {
                this.getLogger().severe("Not enough data points: #" + data);
                DataContainer result = (DataContainer)data.getClone();
                if (result instanceof NotesHandler) {
                    ((NotesHandler)result).getNotes().addWarning(((Object)((Object)this)).getClass(), "Not enough data points!");
                }
                return (T)result;
            }
            this.m_Coefficients = SavitzkyGolay.determineCoefficients(this.m_NumPointsLeft, this.m_NumPointsRight, this.m_PolynomialOrder, this.m_DerivativeOrder, this.isLoggingEnabled());
        }
        DataContainer result = data.getHeader();
        List points = data.toList();
        int width = this.m_NumPointsLeft + this.m_NumPointsRight + 1;
        for (int i = 0; i <= points.size() - width; ++i) {
            double value = 0.0;
            for (int n = 0; n < width; ++n) {
                value += this.m_Coefficients[n] * this.getValue((DataPoint)points.get(i + n));
            }
            DataPoint newPoint = this.newDataPoint((DataPoint)points.get(i + this.m_NumPointsLeft), value);
            this.postProcess((DataPoint)points.get(i + this.m_NumPointsLeft), newPoint);
            result.add((Object)newPoint);
        }
        return (T)result;
    }
}

