/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import java.util.List;

public abstract class AbstractSimpleSavitzkyGolay<T extends DataContainer>
extends AbstractFilter<T>
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 343582700139292935L;
    protected int m_WindowSize;

    public String globalInfo() {
        return "A filter that applies a simplified Savitzky-Golay smoothing.\n\nFor more information on Savitzky-Golay see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "A. Savitzky and Marcel J.E. Golay");
        result.setValue(TechnicalInformation.Field.TITLE, "Smoothing and Differentiation of Data by Simplified Least Squares Procedures");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Analytical Chemistry");
        result.setValue(TechnicalInformation.Field.VOLUME, "36");
        result.setValue(TechnicalInformation.Field.PAGES, "1627-1639");
        result.setValue(TechnicalInformation.Field.YEAR, "1964");
        result.setValue(TechnicalInformation.Field.HTTP, "http://dx.doi.org/10.1021/ac60214a047");
        return result;
    }

    protected void initialize() {
        super.initialize();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("windowSize", "windowSize", (Object)7);
    }

    public void setWindowSize(int value) {
        if (value == -1 || value >= 3 && value % 2 == 1) {
            this.m_WindowSize = value;
            this.reset();
        } else {
            this.getLogger().severe("The window size must be at least 3 and an odd number or -1 if no optimization is to be used (provided: " + value + ")!");
        }
    }

    public int getWindowSize() {
        return this.m_WindowSize;
    }

    public String windowSizeTipText() {
        return "The window size to use for smoothing.";
    }

    protected abstract double getValue(DataPoint var1);

    protected abstract DataPoint newDataPoint(DataPoint var1, double var2);

    protected T processData(T data) {
        int winOff;
        DataContainer result = data.getHeader();
        List points = data.toList();
        for (int i = winOff = (this.m_WindowSize - 1) / 2; i < points.size() - winOff; ++i) {
            double y = 0.0;
            for (int j = -winOff; j <= winOff; ++j) {
                y += (double)j * this.getValue((DataPoint)points.get(i + j));
            }
            DataPoint newPoint = this.newDataPoint((DataPoint)points.get(i - winOff), y);
            result.add((Object)newPoint);
        }
        return (T)result;
    }
}

