/*
 * Decompiled with CFR 0.152.
 */
package adams.data.smoothing;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.container.DataContainer;
import adams.data.filter.AbstractSavitzkyGolay;
import adams.data.smoothing.AbstractSmoother;

public abstract class AbstractSavitzkyGolayBased<T extends DataContainer>
extends AbstractSmoother<T>
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -4052647569528377770L;
    protected AbstractSavitzkyGolay m_SavitzkyGolay;

    public String globalInfo() {
        return "A Savitzky-Golay based smoothing algorithm.\nIt uses a Savitzky-Golay filter with derivative order 0 and adding of mass-spec data turned on.\n\nFor more information on Savitzky-Golay see:\n\n" + this.getTechnicalInformation().toString();
    }

    protected abstract AbstractSavitzkyGolay getDefault();

    public TechnicalInformation getTechnicalInformation() {
        return this.getDefault().getTechnicalInformation();
    }

    protected void initialize() {
        super.initialize();
        this.m_SavitzkyGolay = this.getDefault();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("polynomial", "polynomialOrder", (Object)2, (Number)2, null);
        this.m_OptionManager.add("left", "numPointsLeft", (Object)3, (Number)0, null);
        this.m_OptionManager.add("right", "numPointsRight", (Object)3, (Number)0, null);
    }

    public void setPolynomialOrder(int value) {
        this.m_SavitzkyGolay.setPolynomialOrder(value);
    }

    public int getPolynomialOrder() {
        return this.m_SavitzkyGolay.getPolynomialOrder();
    }

    public String polynomialOrderTipText() {
        return this.m_SavitzkyGolay.polynomialOrderTipText();
    }

    public void setNumPointsLeft(int value) {
        this.m_SavitzkyGolay.setNumPointsLeft(value);
    }

    public int getNumPointsLeft() {
        return this.m_SavitzkyGolay.getNumPointsLeft();
    }

    public String numPointsLeftTipText() {
        return this.m_SavitzkyGolay.numPointsLeftTipText();
    }

    public void setNumPointsRight(int value) {
        this.m_SavitzkyGolay.setNumPointsRight(value);
    }

    public int getNumPointsRight() {
        return this.m_SavitzkyGolay.getNumPointsRight();
    }

    public String numPointsRightTipText() {
        return this.m_SavitzkyGolay.numPointsRightTipText();
    }

    protected T processData(T data) {
        DataContainer result = this.m_SavitzkyGolay.filter((DataContainer)data);
        this.m_SavitzkyGolay.cleanUp();
        return (T)result;
    }
}

