/*
 * Decompiled with CFR 0.152.
 */
package edu.umbc.cs.maple.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

public class MathUtils {
    static Random randGenerator = new Random(System.currentTimeMillis());
    static double MACHINE_PRECISION = 0.0;
    static final double LOG2;

    public static int[] reverseCuthillMcKee(int[][] adjacencyLists, boolean runTwiceForOptimalResult) {
        int minBranchingFactor = Integer.MAX_VALUE;
        int minBranchingFactorVertex = -1;
        for (int v = 0; v < adjacencyLists.length; ++v) {
            int branchingFactor = adjacencyLists[v].length;
            if (branchingFactor >= minBranchingFactor) continue;
            minBranchingFactor = branchingFactor;
            minBranchingFactorVertex = v;
        }
        int[] permutation = MathUtils.reverseCuthillMcKee(adjacencyLists, minBranchingFactorVertex);
        if (!runTwiceForOptimalResult) {
            return permutation;
        }
        return MathUtils.reverseCuthillMcKee(adjacencyLists, permutation[0]);
    }

    private static int[] reverseCuthillMcKee(int[][] adjacencyLists, int startingVertex) {
        if (startingVertex < 0 || startingVertex >= adjacencyLists.length) {
            throw new IllegalArgumentException("startingVertex must be in [0," + adjacencyLists.length + ").");
        }
        int numVertices = adjacencyLists.length;
        HashSet<Integer> unvisitedVertices = new HashSet<Integer>();
        int[] branchingFactors = new int[numVertices];
        for (int v = 0; v < numVertices; ++v) {
            branchingFactors[v] = adjacencyLists[v].length;
            unvisitedVertices.add(v);
        }
        ArrayList<Integer> ordering = new ArrayList<Integer>();
        ordering.add(startingVertex);
        unvisitedVertices.remove(startingVertex);
        int i = 0;
        while (ordering.size() < numVertices) {
            int[] neighborOrder;
            if (i == ordering.size()) {
                int minBranchingFactor = Integer.MAX_VALUE;
                int minBranchingFactorVertex = -1;
                Iterator iterator = unvisitedVertices.iterator();
                while (iterator.hasNext()) {
                    int v = (Integer)iterator.next();
                    if (branchingFactors[v] >= minBranchingFactor) continue;
                    minBranchingFactor = branchingFactors[v];
                    minBranchingFactorVertex = v;
                }
                ordering.add(minBranchingFactorVertex);
                unvisitedVertices.remove(minBranchingFactorVertex);
            }
            int currVertex = (Integer)ordering.get(i++);
            int[] neighborDegrees = new int[adjacencyLists[currVertex].length];
            for (int nIdx = 0; nIdx < adjacencyLists[currVertex].length; ++nIdx) {
                int neighbor = adjacencyLists[currVertex][nIdx];
                neighborDegrees[nIdx] = branchingFactors[neighbor];
            }
            for (int nIdx : neighborOrder = MathUtils.sortOrder(neighborDegrees)) {
                int neighbor = adjacencyLists[currVertex][nIdx];
                if (!unvisitedVertices.contains(neighbor)) continue;
                ordering.add(neighbor);
                unvisitedVertices.remove(neighbor);
            }
        }
        int[] permutation = new int[ordering.size()];
        i = ordering.size() - 1;
        Iterator iterator = ordering.iterator();
        while (iterator.hasNext()) {
            int v = (Integer)iterator.next();
            permutation[i--] = v;
        }
        return permutation;
    }

    public static int[] permutation(int n) {
        return MathUtils.permutation(n, MathUtils.getRandomGenerator());
    }

    public static int[] permutation(int n, Random rand) {
        int[] values = new int[n];
        for (int i = 0; i < n; ++i) {
            values[i] = i;
        }
        Collections.shuffle(Arrays.asList(new int[][]{values}));
        return values;
    }

    public static int[] append(int[] v1, int d) {
        int[] newVector = new int[v1.length + 1];
        System.arraycopy(v1, 0, newVector, 0, v1.length);
        newVector[v1.length] = d;
        return newVector;
    }

    public static double[] append(double[] v1, double d) {
        double[] newVector = new double[v1.length + 1];
        System.arraycopy(v1, 0, newVector, 0, v1.length);
        newVector[v1.length] = d;
        return newVector;
    }

    public static double[] append(double[] v1, double[] v2) {
        double[] newVector = new double[v1.length + v2.length];
        System.arraycopy(v1, 0, newVector, 0, v1.length);
        System.arraycopy(v2, 0, newVector, v1.length, v2.length);
        return newVector;
    }

    public static int[] append(int[] v1, int[] v2) {
        int[] newVector = new int[v1.length + v2.length];
        System.arraycopy(v1, 0, newVector, 0, v1.length);
        System.arraycopy(v2, 0, newVector, v1.length, v2.length);
        return newVector;
    }

    public static double[] vectorAdd(double[] v1, double[] v2) {
        double[] result = new double[v1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = v1[i] + v2[i];
        }
        return result;
    }

    public static double[] vectorSubtract(double[] v1, double[] v2) {
        double[] result = new double[v1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = v1[i] - v2[i];
        }
        return result;
    }

    public static double[] vectorMultiply(double s, double[] v) {
        double[] result = new double[v.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = s * v[i];
        }
        return result;
    }

    public static double vectorL2Norm(double[] v) {
        double norm = 0.0;
        for (double d : v) {
            norm += Math.pow(d, 2.0);
        }
        return Math.sqrt(norm);
    }

    public static double[] vectorNormalize(double[] v) {
        double[] result = new double[v.length];
        double sum = 0.0;
        for (double d : v) {
            sum += d;
        }
        for (int i = 0; i < v.length; ++i) {
            result[i] = v[i] / sum;
        }
        return result;
    }

    public static Random getRandomGenerator() {
        return randGenerator;
    }

    public static void initializeRandomGenerator(long seed) {
        randGenerator = new Random(seed);
    }

    public static double nextRandomGaussian(double mean, double stdev) {
        return MathUtils.nextRandomGaussian(MathUtils.getRandomGenerator(), mean, stdev);
    }

    public static double nextRandomGaussian(Random randGenerator, double mean, double stdev) {
        return mean + stdev * randGenerator.nextGaussian();
    }

    public static double rmse(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Arrays must be the same length.");
        }
        double rmse = 0.0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            rmse += Math.pow(a[i] - b[i], 2.0);
        }
        rmse = Math.sqrt(rmse / (double)n);
        return rmse;
    }

    public static void main(String[] args) {
        MathUtils.sampleWithoutReplacement(new String[]{"A", "B", "C", "D"}, new double[]{0.15, 0.35, 0.15, 0.35}, 3);
    }

    public static <T> Collection<T> sampleWithoutReplacement(T[] objs, double[] probabilityDistribution, int numSamples) {
        if (numSamples > objs.length) {
            throw new IllegalArgumentException("Cannot sample (without replacement) more items than we have.");
        }
        if (objs.length != probabilityDistribution.length) {
            throw new IllegalArgumentException("Each object must have an associated probability");
        }
        if (numSamples == objs.length) {
            ArrayList<T> chosenObjs = new ArrayList<T>();
            for (T obj : objs) {
                chosenObjs.add(obj);
            }
            return chosenObjs;
        }
        ArrayList<T> chosenObjs = new ArrayList<T>();
        for (int sample = 0; sample < numSamples; ++sample) {
            double normalizer = MathUtils.sum(probabilityDistribution);
            double[] cumulativeDistribution = new double[objs.length];
            for (int i = 1; i < probabilityDistribution.length; ++i) {
                cumulativeDistribution[i] = cumulativeDistribution[i - 1] + probabilityDistribution[i - 1] / normalizer;
            }
            double value = MathUtils.getRandomGenerator().nextDouble();
            int index = Arrays.binarySearch(cumulativeDistribution, value);
            if (index < 0) {
                index = (index + 2) * -1;
            }
            while (index < probabilityDistribution.length && probabilityDistribution[index] == 0.0) {
                ++index;
            }
            chosenObjs.add(objs[index]);
            probabilityDistribution[index] = 0.0;
        }
        return chosenObjs;
    }

    public static <T> Collection<T> sampleWithReplacement(T[] objs, double[] probabilityDistribution, int numSamples) {
        if (objs.length != probabilityDistribution.length) {
            throw new IllegalArgumentException("Each object must have an associated probability");
        }
        double normalizer = MathUtils.sum(probabilityDistribution);
        double[] cumulativeDistribution = new double[objs.length];
        for (int i = 1; i < probabilityDistribution.length; ++i) {
            cumulativeDistribution[i] = cumulativeDistribution[i - 1] + probabilityDistribution[i - 1] / normalizer;
        }
        ArrayList<T> chosenObjs = new ArrayList<T>();
        for (int sample = 0; sample < numSamples; ++sample) {
            double value = MathUtils.getRandomGenerator().nextDouble();
            int index = Arrays.binarySearch(cumulativeDistribution, value);
            if (index < 0) {
                index = (index + 2) * -1;
            }
            chosenObjs.add(objs[index]);
        }
        return chosenObjs;
    }

    public static double capValue(double value, double minValue, double maxValue) {
        if (value < minValue) {
            return minValue;
        }
        if (value > maxValue) {
            return maxValue;
        }
        return value;
    }

    public static int capValue(int value, int minValue, int maxValue) {
        if (value < minValue) {
            return minValue;
        }
        if (value > maxValue) {
            return maxValue;
        }
        return value;
    }

    public static void rangeCheck(int value, int min, int max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException("Value falls out of required range [" + min + "," + max + "].");
        }
    }

    public static void rangeCheck(double value, double min, double max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException("Value falls out of required range [" + min + "," + max + "].");
        }
    }

    public static final double round(double d, int decimalPlacesRequired) {
        double factor = Math.pow(10.0, decimalPlacesRequired);
        return (double)Math.round(d * factor) / factor;
    }

    public static final int roundToMultiple(int value, int multipleOf) {
        return (int)Math.round((double)value / (double)multipleOf) * multipleOf;
    }

    public static int minIndex(double[] v) {
        if (v == null || v.length == 0) {
            throw new IllegalArgumentException("v cannot be empty.");
        }
        double minValue = MathUtils.minValue(v);
        for (int i = 0; i < v.length; ++i) {
            if (v[i] != minValue) continue;
            return i;
        }
        return -1;
    }

    public static int minIndex(int[] v) {
        if (v == null || v.length == 0) {
            throw new IllegalArgumentException("v cannot be empty.");
        }
        int minValue = MathUtils.minValue(v);
        for (int i = 0; i < v.length; ++i) {
            if (v[i] != minValue) continue;
            return i;
        }
        return -1;
    }

    public static int minIndexRand(double[] v) {
        if (v == null || v.length == 0) {
            throw new IllegalArgumentException("v cannot be empty.");
        }
        double minValue = MathUtils.minValue(v);
        ArrayList<Integer> minIndices = new ArrayList<Integer>();
        for (int i = 0; i < v.length; ++i) {
            if (v[i] != minValue) continue;
            minIndices.add(i);
        }
        if (minIndices.size() == 1) {
            return (Integer)minIndices.get(0);
        }
        int randIndex = MathUtils.getRandomGenerator().nextInt(minIndices.size());
        return (Integer)minIndices.get(randIndex);
    }

    public static int minIndexRand(int[] v) {
        if (v == null || v.length == 0) {
            throw new IllegalArgumentException("v cannot be empty.");
        }
        int minValue = MathUtils.minValue(v);
        ArrayList<Integer> minIndices = new ArrayList<Integer>();
        for (int i = 0; i < v.length; ++i) {
            if (v[i] != minValue) continue;
            minIndices.add(i);
        }
        if (minIndices.size() == 1) {
            return (Integer)minIndices.get(0);
        }
        int randIndex = MathUtils.getRandomGenerator().nextInt(minIndices.size());
        return (Integer)minIndices.get(randIndex);
    }

    public static int maxIndex(double[] v) {
        if (v == null || v.length == 0) {
            throw new IllegalArgumentException("v cannot be empty.");
        }
        double maxValue = MathUtils.maxValue(v);
        for (int i = 0; i < v.length; ++i) {
            if (v[i] != maxValue) continue;
            return i;
        }
        return -1;
    }

    public static int maxIndex(int[] v) {
        if (v == null || v.length == 0) {
            throw new IllegalArgumentException("v cannot be empty.");
        }
        int maxValue = MathUtils.maxValue(v);
        for (int i = 0; i < v.length; ++i) {
            if (v[i] != maxValue) continue;
            return i;
        }
        return -1;
    }

    public static int maxIndexRand(double[] v) {
        if (v == null || v.length == 0) {
            throw new IllegalArgumentException("v cannot be empty.");
        }
        double maxValue = MathUtils.maxValue(v);
        ArrayList<Integer> maxIndices = new ArrayList<Integer>();
        for (int i = 0; i < v.length; ++i) {
            if (v[i] != maxValue) continue;
            maxIndices.add(i);
        }
        if (maxIndices.size() == 1) {
            return (Integer)maxIndices.get(0);
        }
        int randIndex = MathUtils.getRandomGenerator().nextInt(maxIndices.size());
        return (Integer)maxIndices.get(randIndex);
    }

    public static int maxIndexRand(int[] v) {
        if (v == null || v.length == 0) {
            throw new IllegalArgumentException("v cannot be empty.");
        }
        int maxValue = MathUtils.maxValue(v);
        ArrayList<Integer> maxIndices = new ArrayList<Integer>();
        for (int i = 0; i < v.length; ++i) {
            if (v[i] != maxValue) continue;
            maxIndices.add(i);
        }
        if (maxIndices.size() == 1) {
            return (Integer)maxIndices.get(0);
        }
        int randIndex = MathUtils.getRandomGenerator().nextInt(maxIndices.size());
        return (Integer)maxIndices.get(randIndex);
    }

    public static int maxValue(int[] values) {
        int maxValue = Integer.MIN_VALUE;
        for (int val : values) {
            maxValue = maxValue < val ? val : maxValue;
        }
        return maxValue;
    }

    public static double maxValue(double[] values) {
        double maxValue = Double.MIN_VALUE;
        for (double val : values) {
            maxValue = maxValue < val ? val : maxValue;
        }
        return maxValue;
    }

    public static double minValue(double[] values) {
        double minValue = Double.MAX_VALUE;
        for (double val : values) {
            minValue = minValue > val ? val : minValue;
        }
        return minValue;
    }

    public static int minValue(int[] values) {
        int minValue = Integer.MAX_VALUE;
        for (int val : values) {
            minValue = minValue > val ? val : minValue;
        }
        return minValue;
    }

    public static double mean(double[] values) {
        return MathUtils.sum(values) / (double)values.length;
    }

    public static double mean(int[] values) {
        return (double)MathUtils.sum(values) / (double)values.length;
    }

    public static double sum(double[] values) {
        double sumValue = 0.0;
        for (double val : values) {
            sumValue += val;
        }
        return sumValue;
    }

    public static int sum(int[] values) {
        int sumValue = 0;
        for (int val : values) {
            sumValue += val;
        }
        return sumValue;
    }

    public static double[] arrayAdd(double[] d1, double[] d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("Arrays cannot be null.");
        }
        if (d1.length != d2.length) {
            throw new IllegalArgumentException("Arrays must be the same length.");
        }
        double[] dSum = new double[d1.length];
        for (int i = 0; i < d1.length; ++i) {
            dSum[i] = d1[i] + d2[i];
        }
        return dSum;
    }

    public static double[] arrayDivide(double[] d1, double denominator) {
        if (d1 == null) {
            throw new IllegalArgumentException("Array cannot be null.");
        }
        double[] dDivide = new double[d1.length];
        for (int i = 0; i < d1.length; ++i) {
            dDivide[i] = d1[i] / denominator;
        }
        return dDivide;
    }

    public static int[] sortOrder(int[] values) {
        Object[] array = new SortOrder[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = new SortOrder<Integer>(values[i], i);
        }
        Collections.shuffle(Arrays.asList(array), MathUtils.getRandomGenerator());
        Arrays.sort(array);
        int[] order = new int[values.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = ((SortOrder)array[i]).getIndex();
        }
        return order;
    }

    public static int[] sortOrder(double[] values) {
        Object[] array = new SortOrder[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = new SortOrder<Double>(values[i], i);
        }
        Collections.shuffle(Arrays.asList(array), MathUtils.getRandomGenerator());
        Arrays.sort(array);
        int[] order = new int[values.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = ((SortOrder)array[i]).getIndex();
        }
        return order;
    }

    public static int[] reverse(int[] array) {
        int[] reverseArray = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            reverseArray[array.length - 1 - i] = array[i];
        }
        return reverseArray;
    }

    public static double[] reverse(double[] array) {
        double[] reverseArray = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            reverseArray[array.length - 1 - i] = array[i];
        }
        return reverseArray;
    }

    public static double getMachinePrecision() {
        return MACHINE_PRECISION;
    }

    public static boolean isApproxEqual(double value1, double value2) {
        return MathUtils.isApproxEqual(value1, value2, MathUtils.getMachinePrecision());
    }

    public static boolean isApproxEqual(double value1, double value2, double precision) {
        return Math.abs(value1 - value2) <= precision;
    }

    public static double correlation(int[] p, int[] q) {
        if (p == null || q == null) {
            throw new IllegalArgumentException("p and q cannot be null");
        }
        if (p.length != q.length) {
            throw new IllegalArgumentException("p and q must be the same length");
        }
        int sumP = 0;
        int sumQ = 0;
        int sumPSquared = 0;
        int sumQSquared = 0;
        int sumPQ = 0;
        for (int i = 0; i < p.length; ++i) {
            sumP += p[i];
            sumQ += q[i];
            sumPSquared += p[i] * p[i];
            sumQSquared += q[i] * q[i];
            sumPQ += p[i] * q[i];
        }
        double r = (double)(p.length * sumPQ - sumP * sumQ) / Math.sqrt((long)(p.length * sumPSquared - sumP * sumP) * (long)(p.length * sumQSquared - sumQ * sumQ));
        return r;
    }

    public static double correlation(double[] p, double[] q) {
        if (p == null || q == null) {
            throw new IllegalArgumentException("p and q cannot be null");
        }
        if (p.length != q.length) {
            throw new IllegalArgumentException("p and q must be the same length");
        }
        double sumP = 0.0;
        double sumQ = 0.0;
        double sumPSquared = 0.0;
        double sumQSquared = 0.0;
        double sumPQ = 0.0;
        for (int i = 0; i < p.length; ++i) {
            sumP += p[i];
            sumQ += q[i];
            sumPSquared += p[i] * p[i];
            sumQSquared += q[i] * q[i];
            sumPQ += p[i] * q[i];
        }
        double r = ((double)p.length * sumPQ - sumP * sumQ) / Math.sqrt(((double)p.length * sumPSquared - sumP * sumP) * ((double)p.length * sumQSquared - sumQ * sumQ));
        return r;
    }

    public static double pairwiseAgreement(int[] p, int[] q) {
        if (p == null || q == null) {
            throw new IllegalArgumentException("p and q cannot be null");
        }
        if (p.length != q.length) {
            throw new IllegalArgumentException("p and q must be the same length");
        }
        int numSamePairs = 0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] != q[i]) continue;
            ++numSamePairs;
        }
        return (double)numSamePairs / (double)p.length;
    }

    public static int[] uniqueValues(int[] v) {
        HashSet<Integer> uniqueValues = new HashSet<Integer>();
        for (int i = 0; i < v.length; ++i) {
            uniqueValues.add(v[i]);
        }
        int[] vUnique = new int[uniqueValues.size()];
        int i = 0;
        for (Integer uniqueValue : uniqueValues) {
            vUnique[i++] = uniqueValue;
        }
        return vUnique;
    }

    public static double[] uniqueValues(double[] v) {
        HashSet<Double> uniqueValues = new HashSet<Double>();
        for (int i = 0; i < v.length; ++i) {
            uniqueValues.add(v[i]);
        }
        double[] vUnique = new double[uniqueValues.size()];
        int i = 0;
        for (Double uniqueValue : uniqueValues) {
            vUnique[i++] = uniqueValue;
        }
        return vUnique;
    }

    public static double[][] getConfusionMatrix(int[] p, int[] q) {
        int i;
        if (p.length != q.length) {
            throw new IllegalArgumentException("p and q must be the same length.");
        }
        int[] classes = MathUtils.uniqueValues(MathUtils.append(p, q));
        int n = p.length;
        double[][] confusionMatrix = new double[classes.length][classes.length];
        for (i = 0; i < n; ++i) {
            int qiClassIdx;
            int piClassIdx;
            for (piClassIdx = 0; piClassIdx < classes.length && p[i] != classes[piClassIdx]; ++piClassIdx) {
            }
            for (qiClassIdx = 0; qiClassIdx < classes.length && q[i] != classes[qiClassIdx]; ++qiClassIdx) {
            }
            double[] dArray = confusionMatrix[piClassIdx];
            int n2 = qiClassIdx;
            dArray[n2] = dArray[n2] + 1.0;
        }
        for (i = 0; i < confusionMatrix.length; ++i) {
            int j = 0;
            while (j < confusionMatrix.length) {
                double[] dArray = confusionMatrix[i];
                int n3 = j++;
                dArray[n3] = dArray[n3] / (double)n;
            }
        }
        return confusionMatrix;
    }

    public static double mutualInformation(int[] p, int[] q) {
        double[][] confusionMatrix = MathUtils.getConfusionMatrix(p, q);
        double[] rowsum = new double[confusionMatrix.length];
        double[] colsum = new double[confusionMatrix.length];
        for (int i = 0; i < confusionMatrix.length; ++i) {
            for (int j = 0; j < confusionMatrix.length; ++j) {
                int n = i;
                rowsum[n] = rowsum[n] + confusionMatrix[i][j];
                int n2 = j;
                colsum[n2] = colsum[n2] + confusionMatrix[i][j];
            }
        }
        double mutualInformation = 0.0;
        for (int i = 0; i < confusionMatrix.length; ++i) {
            for (int j = 0; j < confusionMatrix.length; ++j) {
                double deltaMI = 0.0;
                if (confusionMatrix[i][j] != 0.0) {
                    deltaMI = confusionMatrix[i][j] * MathUtils.log2(confusionMatrix[i][j] / (rowsum[i] * colsum[j]));
                }
                if (Double.isNaN(deltaMI)) {
                    throw new IllegalStateException("MI is NaN!");
                }
                mutualInformation += deltaMI;
            }
        }
        return mutualInformation;
    }

    public static double computeSimilarity(int[] targetV, int[] v, SimilarityMetric similarityMetric) {
        switch (similarityMetric) {
            case CORRELATION: {
                return MathUtils.correlation(targetV, v);
            }
            case MUTUAL_INFORMATION: {
                return MathUtils.mutualInformation(targetV, v);
            }
            case ACCURACY: {
                return MathUtils.pairwiseAgreement(targetV, v);
            }
        }
        return Double.NaN;
    }

    public static double log2(double d) {
        return Math.log(d) / LOG2;
    }

    static {
        MACHINE_PRECISION = 1.0;
        double one = 1.0;
        while ((one = 1.0 + (MACHINE_PRECISION /= 2.0)) > 1.0) {
        }
        LOG2 = Math.log(2.0);
    }

    public static enum SimilarityMetric {
        CORRELATION,
        MUTUAL_INFORMATION,
        ACCURACY;

    }

    static class SortOrder<T extends Comparable<T>>
    implements Comparable<SortOrder<T>> {
        T m_object;
        int m_index;

        public SortOrder(T o, int index) {
            this.m_object = o;
            this.m_index = index;
        }

        public T getObject() {
            return this.m_object;
        }

        public int getIndex() {
            return this.m_index;
        }

        @Override
        public int compareTo(SortOrder<T> o) {
            return this.m_object.compareTo(o.m_object);
        }
    }
}

