/*
 * Decompiled with CFR 0.152.
 */
package edu.umbc.cs.maple.utils;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import edu.umbc.cs.maple.utils.MathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import optimization.Fmin;
import optimization.Fmin_methods;

public class JamaUtils {
    public static Matrix getcol(Matrix m, int col) {
        return m.getMatrix(0, m.getRowDimension() - 1, col, col);
    }

    public static Matrix getcolumns(Matrix m, int[] columns) {
        Matrix colMatrix = new Matrix(m.getRowDimension(), columns.length);
        for (int i = 0; i < columns.length; ++i) {
            JamaUtils.setcol(colMatrix, i, JamaUtils.getcol(m, columns[i]));
        }
        return colMatrix;
    }

    public static Matrix getrow(Matrix m, int row) {
        return m.getMatrix(row, row, 0, m.getColumnDimension() - 1);
    }

    public static Matrix getrows(Matrix m, int[] rows) {
        Matrix rowMatrix = new Matrix(rows.length, m.getColumnDimension());
        for (int i = 0; i < rows.length; ++i) {
            JamaUtils.setrow(rowMatrix, i, JamaUtils.getrow(m, rows[i]));
        }
        return rowMatrix;
    }

    public static void setrow(Matrix m, int row, Matrix values) {
        if (!JamaUtils.isRowVector(values)) {
            throw new IllegalArgumentException("values must be a row vector.");
        }
        m.setMatrix(row, row, 0, m.getColumnDimension() - 1, values);
    }

    public static void setcol(Matrix m, int col, Matrix values) {
        if (!JamaUtils.isColumnVector(values)) {
            throw new IllegalArgumentException("values must be a column vector.");
        }
        m.setMatrix(0, m.getRowDimension() - 1, col, col, values);
    }

    public static void setcol(Matrix m, int col, double[] values) {
        if (values.length != m.getRowDimension()) {
            throw new IllegalArgumentException("values must have the same number of rows as the matrix.");
        }
        for (int i = 0; i < values.length; ++i) {
            m.set(i, col, values[i]);
        }
    }

    public static Matrix rowAppend(Matrix m, Matrix n) {
        int mNumRows = m.getRowDimension();
        int mNumCols = m.getColumnDimension();
        int nNumRows = n.getRowDimension();
        int nNumCols = n.getColumnDimension();
        if (mNumCols != nNumCols) {
            throw new IllegalArgumentException("Number of columns must be identical to row-append.");
        }
        Matrix x = new Matrix(mNumRows + nNumRows, mNumCols);
        x.setMatrix(0, mNumRows - 1, 0, mNumCols - 1, m);
        x.setMatrix(mNumRows, mNumRows + nNumRows - 1, 0, mNumCols - 1, n);
        return x;
    }

    public static Matrix columnAppend(Matrix m, Matrix n) {
        int mNumRows = m.getRowDimension();
        int mNumCols = m.getColumnDimension();
        int nNumRows = n.getRowDimension();
        int nNumCols = n.getColumnDimension();
        if (mNumRows != nNumRows) {
            throw new IllegalArgumentException("Number of rows must be identical to column-append.");
        }
        Matrix x = new Matrix(mNumRows, mNumCols + nNumCols);
        x.setMatrix(0, mNumRows - 1, 0, mNumCols - 1, m);
        x.setMatrix(0, mNumRows - 1, mNumCols, mNumCols + nNumCols - 1, n);
        return x;
    }

    public static Matrix deleteRow(Matrix m, int row) {
        int numRows = m.getRowDimension();
        int numCols = m.getColumnDimension();
        Matrix m2 = new Matrix(numRows - 1, numCols);
        int m2i = 0;
        for (int mi = 0; mi < numRows; ++mi) {
            if (mi == row) continue;
            for (int j = 0; j < numCols; ++j) {
                m2.set(m2i, j, m.get(mi, j));
            }
            ++m2i;
        }
        return m2;
    }

    public static Matrix deleteCol(Matrix m, int col) {
        int numRows = m.getRowDimension();
        int numCols = m.getColumnDimension();
        Matrix m2 = new Matrix(numRows, numCols - 1);
        int m2j = 0;
        for (int mj = 0; mj < numCols; ++mj) {
            if (mj == col) continue;
            for (int i = 0; i < numRows; ++i) {
                m2.set(i, m2j, m.get(i, mj));
            }
            ++m2j;
        }
        return m2;
    }

    public static double rowsum(Matrix m, int row) {
        if (row < 0 || row >= m.getRowDimension()) {
            throw new IllegalArgumentException("row exceeds the row indices [0," + (m.getRowDimension() - 1) + "] for m.");
        }
        double rowsum = 0.0;
        int numCols = m.getColumnDimension();
        for (int j = 0; j < numCols; ++j) {
            rowsum += m.get(row, j);
        }
        return rowsum;
    }

    public static double colsum(Matrix m, int col) {
        if (col < 0 || col >= m.getColumnDimension()) {
            throw new IllegalArgumentException("col exceeds the column indices [0," + (m.getColumnDimension() - 1) + "] for m.");
        }
        double colsum = 0.0;
        int numRows = m.getRowDimension();
        for (int i = 0; i < numRows; ++i) {
            colsum += m.get(i, col);
        }
        return colsum;
    }

    public static Matrix rowsum(Matrix m) {
        int numRows = m.getRowDimension();
        int numCols = m.getColumnDimension();
        Matrix sum = new Matrix(numRows, 1);
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                sum.set(i, 0, sum.get(i, 0) + m.get(i, j));
            }
        }
        return sum;
    }

    public static Matrix colsum(Matrix m) {
        int numRows = m.getRowDimension();
        int numCols = m.getColumnDimension();
        Matrix sum = new Matrix(1, numCols);
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                sum.set(0, j, sum.get(0, j) + m.get(i, j));
            }
        }
        return sum;
    }

    public static double sum(Matrix m) {
        int numRows = m.getRowDimension();
        int numCols = m.getColumnDimension();
        double sum = 0.0;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                sum += m.get(i, j);
            }
        }
        return sum;
    }

    public static boolean isRowVector(Matrix m) {
        return m.getRowDimension() == 1;
    }

    public static boolean isColumnVector(Matrix m) {
        return m.getColumnDimension() == 1;
    }

    public static Matrix makeColumnVector(Matrix m) {
        if (JamaUtils.isColumnVector(m)) {
            return m;
        }
        if (JamaUtils.isRowVector(m)) {
            return m.transpose();
        }
        throw new IllegalArgumentException("m is not a vector.");
    }

    public static Matrix makeRowVector(Matrix m) {
        if (JamaUtils.isRowVector(m)) {
            return m;
        }
        if (JamaUtils.isColumnVector(m)) {
            return m.transpose();
        }
        throw new IllegalArgumentException("m is not a vector.");
    }

    public static double dotproduct(Matrix m1, Matrix m2) {
        Matrix m1colVector = JamaUtils.makeColumnVector(m1);
        Matrix m2colVector = JamaUtils.makeColumnVector(m2);
        int n = m1colVector.getRowDimension();
        if (n != m2colVector.getRowDimension()) {
            throw new IllegalArgumentException("m1 and m2 must have the same number of elements.");
        }
        double scalarProduct = 0.0;
        for (int row = 0; row < n; ++row) {
            scalarProduct += m1colVector.get(row, 0) * m2colVector.get(row, 0);
        }
        return scalarProduct;
    }

    public static boolean isSymmetric(Matrix m) {
        int numRows = m.getRowDimension();
        int numCols = m.getColumnDimension();
        for (int i = 0; i < numRows; ++i) {
            for (int j = i + 1; j < numCols; ++j) {
                if (m.get(i, j) == m.get(j, i)) continue;
                return false;
            }
        }
        return true;
    }

    public static void makeMatrixSymmetric(Matrix m, Function f) {
        int numRows = m.getRowDimension();
        int numCols = m.getColumnDimension();
        for (int i = 0; i < numRows; ++i) {
            for (int j = i; j < numCols; ++j) {
                double value1 = m.get(i, j);
                double value2 = m.get(j, i);
                double similarity = f.applyFunction(value1, value2);
                m.set(i, j, similarity);
                m.set(j, i, similarity);
            }
        }
    }

    public static Matrix normalize(Matrix m) {
        int numRows = m.getRowDimension();
        int numCols = m.getColumnDimension();
        double sum = 0.0;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                sum += m.get(i, j);
            }
        }
        Matrix normalizedM = new Matrix(numRows, numCols);
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                normalizedM.set(i, j, m.get(i, j) / sum);
            }
        }
        return normalizedM;
    }

    public static double getMax(Matrix m) {
        int numRows = m.getRowDimension();
        int numCols = m.getColumnDimension();
        double maxValue = Double.MIN_VALUE;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                maxValue = Math.max(maxValue, m.get(i, j));
            }
        }
        return maxValue;
    }

    public static double getMin(Matrix m) {
        int numRows = m.getRowDimension();
        int numCols = m.getColumnDimension();
        double minValue = Double.MAX_VALUE;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                minValue = Math.min(minValue, m.get(i, j));
            }
        }
        return minValue;
    }

    public static Matrix ones(int numRows, int numCols) {
        return new Matrix(numRows, numCols, 1.0);
    }

    public static Matrix regLeastSquares(Matrix A, Matrix b) {
        int n = b.getRowDimension();
        if (A.getRowDimension() != n) {
            throw new IllegalArgumentException("A and b are incompatible sizes.");
        }
        double lambda = JamaUtils.gcv(A, b);
        return JamaUtils.regLeastSquares(A, b, lambda);
    }

    public static Matrix regLeastSquares(Matrix A, Matrix b, double lambda) {
        int m = A.getColumnDimension();
        Matrix regop = Matrix.identity((int)m, (int)m).times(Math.pow(lambda, 2.0));
        return JamaUtils.regLeastSquares(A, b, regop);
    }

    public static Matrix regLeastSquares(Matrix A, Matrix b, Matrix regop) {
        int m = A.getColumnDimension();
        int n = b.getRowDimension();
        if (A.getRowDimension() != n) {
            throw new IllegalArgumentException("A and b are incompatible sizes.");
        }
        if (regop.getRowDimension() != m || regop.getColumnDimension() != m) {
            throw new IllegalArgumentException("A and regop are incompatible sizes.");
        }
        Matrix x = A.transpose().times(A).plus(regop).inverse().times(A.transpose()).times(b);
        return x;
    }

    protected static double gcv(Matrix A, Matrix b) {
        SingularValueDecomposition Asvd;
        int AnumRows = A.getRowDimension();
        int AnumCols = A.getColumnDimension();
        Matrix U = null;
        double[] s = null;
        if (AnumRows >= AnumCols) {
            Asvd = A.svd();
            U = Asvd.getU();
            s = Asvd.getSingularValues();
        } else {
            Asvd = A.transpose().svd();
            U = Asvd.getV();
            s = Asvd.getSingularValues();
        }
        int n = U.getRowDimension();
        int q = U.getColumnDimension();
        U = new Matrix(U.getArray());
        Matrix fc = U.transpose().times(b);
        double[] s2 = new double[q];
        for (int i = 0; i < q; ++i) {
            s2[i] = Math.pow(s[i], 2.0);
        }
        double rss0 = 0.0;
        if (n > q) {
            double[] tempValues;
            for (double d : tempValues = b.minus(U.times(fc)).getColumnPackedCopy()) {
                rss0 += Math.pow(d, 2.0);
            }
        }
        double eps = Math.pow(2.0, -52.0);
        double h_tol = Math.sqrt((Math.pow(q, 2.0) + (double)q + 1.0) * eps);
        double h_max = MathUtils.maxValue(s);
        double h_min = MathUtils.minValue(s) * h_tol;
        GCVFn gcvfn = new GCVFn();
        gcvfn.setS2(s2);
        gcvfn.setFC(fc);
        gcvfn.setRSS0(rss0);
        gcvfn.setDOF0(n - q);
        double rpar = Fmin.fmin(h_min, h_max, gcvfn, h_tol);
        return rpar;
    }

    public static double rmse(Matrix a, Matrix b) {
        Matrix difference = a.minus(b);
        double rmse = Math.sqrt(JamaUtils.sum(difference.transpose().times(difference)));
        return rmse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Matrix loadSparseMatrix(File file) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            BufferedReader reader = new BufferedReader(fileReader);
            int lineNumber = 0;
            String line = null;
            String[] split = null;
            int rows = -1;
            int cols = -1;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if (!line.matches("^\\d+?.*")) continue;
                split = line.split("[\\s,;]");
                if (split.length != 2) {
                    throw new IllegalArgumentException("Invalid matrix file format:  file must start with the size of the matrix.  Error on line number " + lineNumber + ".");
                }
                rows = Integer.parseInt(split[0]);
                cols = Integer.parseInt(split[1]);
                break;
            }
            Matrix matrix = new Matrix(rows, cols);
            int row = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if (!line.matches("^\\d+?.*")) continue;
                split = line.split("[\\s,;]");
                if (split.length == cols) {
                    for (int col = 0; col < cols; ++col) {
                        matrix.set(row, col, Double.parseDouble(split[col]));
                    }
                } else if (split.length == 3) {
                    matrix.set(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Double.parseDouble(split[2]));
                } else {
                    throw new IllegalArgumentException("Invalid matrix file format:  must be either a full or sparse specification.  Error on line number " + lineNumber + ".");
                }
                ++row;
            }
            Matrix matrix2 = matrix;
            return matrix2;
        }
        catch (IOException e) {
            System.err.println("Invalid file:  " + file.getAbsolutePath());
        }
        finally {
            try {
                fileReader.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static void main(String[] args) {
        Matrix A = new Matrix((double[][])new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 10.0}});
        Matrix b = new Matrix((double[][])new double[][]{{0.5}, {0.7}, {0.8}});
        System.out.print("A = ");
        A.print(4, 2);
        System.out.print("b = ");
        b.print(4, 2);
        System.out.println("Solving Ax = b for x:");
        System.out.println("  Should be [-0.2405; 0.1480; 0.1368] with lambda = 0.41424");
        JamaUtils.regLeastSquares(A, b).print(6, 4);
        System.out.println("Solving Ax = b for x with lambda = 0.1:");
        System.out.println("  Should be [-0.4192; 0.5114; -0.0342]");
        JamaUtils.regLeastSquares(A, b, 0.1).print(6, 4);
        System.out.println("Solving Ax = b for x with lambda = 0.5:");
        System.out.println("  Should be [-0.2120; 0.1180; 0.1416]");
        JamaUtils.regLeastSquares(A, b, 0.5).print(6, 4);
        System.out.println("Solving Ax = b for x with lambda = 1:");
        System.out.println("  Should be [-0.1007; 0.0593; 0.1136]");
        JamaUtils.regLeastSquares(A, b, 1.0).print(6, 4);
        A = new Matrix((double[][])new double[][]{{1.0, 0.2, 0.36}, {1.0, 0.55, 0.65}, {1.0, 0.8, 0.41}});
        b = new Matrix((double[][])new double[][]{{0.25}, {0.17}, {0.98}});
        System.out.print("A = ");
        A.print(4, 2);
        System.out.print("b = ");
        b.print(4, 2);
        System.out.println("Solving Ax = b for x:");
        System.out.println("  Should be [0.2180; 0.2234; 0.0565] with lambda = 1.2105");
        JamaUtils.regLeastSquares(A, b).print(6, 4);
        System.out.println("Solving Ax = b for x with lambda = 0.1:");
        System.out.println("  Should be [0.5278; 1.2681; -1.5171]");
        JamaUtils.regLeastSquares(A, b, 0.1).print(6, 4);
        System.out.println("Solving Ax = b for x with lambda = 0.5:");
        System.out.println("  Should be [0.2347; 0.5517; -0.1535]");
        JamaUtils.regLeastSquares(A, b, 0.5).print(6, 4);
        System.out.println("Solving Ax = b for x with lambda = 1:");
        System.out.println("  Should be [0.2301; 0.2726; 0.0401]");
        JamaUtils.regLeastSquares(A, b, 1.0).print(6, 4);
        A = new Matrix((double[][])new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}, {10.0, 11.0, 12.0}, {13.0, 14.0, 15.0}});
        b = new Matrix((double[][])new double[][]{{0.5}, {0.7}, {0.8}, {0.3}, {0.4}});
        System.out.print("A = ");
        A.print(4, 2);
        System.out.print("b = ");
        b.print(4, 2);
        System.out.println("Solving Ax = b for x:");
        System.out.println("  Should be [-0.3250; -0.0047; 0.3156] with lambda = 0.45081");
        JamaUtils.regLeastSquares(A, b).print(6, 4);
        System.out.println("Solving Ax = b for x with lambda = 0.1:");
        System.out.println("  Should be [-0.3550; -0.0066; 0.3418]");
        JamaUtils.regLeastSquares(A, b, 0.1).print(6, 4);
        System.out.println("Solving Ax = b for x with lambda = 0.5:");
        System.out.println("  Should be [-0.3185; -0.0043; 0.3098]");
        JamaUtils.regLeastSquares(A, b, 0.5).print(6, 4);
        System.out.println("Solving Ax = b for x with lambda = 1:");
        System.out.println("  Should be [-0.2400; 0.0005; 0.2409]");
        JamaUtils.regLeastSquares(A, b, 1.0).print(6, 4);
        A = new Matrix((double[][])new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0}, {6.0, 7.0, 8.0, 9.0, 10.0}, {11.0, 12.0, 13.0, 14.0, 15.0}});
        b = new Matrix((double[][])new double[][]{{0.5}, {0.7}, {0.8}});
        System.out.print("A = ");
        A.print(4, 2);
        System.out.print("b = ");
        b.print(4, 2);
        System.out.println("Solving Ax = b for x:");
        System.out.println("  Should be [-0.0779; -0.0359; 0.0061; 0.0481; 0.0902] with lambda = 0.31315");
        JamaUtils.regLeastSquares(A, b).print(6, 4);
        System.out.println("Solving Ax = b for x with lambda = 0.1:");
        System.out.println("  Should be [-0.0792; -0.0366; 0.0060; 0.0486; 0.0912]");
        JamaUtils.regLeastSquares(A, b, 0.1).print(6, 4);
        System.out.println("Solving Ax = b for x with lambda = 0.5:");
        System.out.println("  Should be [-0.0758; -0.0347; 0.0063; 0.0474; 0.0884]");
        JamaUtils.regLeastSquares(A, b, 0.5).print(6, 4);
        System.out.println("Solving Ax = b for x with lambda = 1:");
        System.out.println("  Should be [-0.0665; -0.0297; 0.0072; 0.0440; 0.0808]");
        JamaUtils.regLeastSquares(A, b, 1.0).print(6, 4);
        System.out.println();
        System.out.println("===============================================");
        System.out.println();
        A = new Matrix((double[][])new double[][]{{2.2, -4.3, 5.4, 1.2, 4.8}, {2.2, 2.3, 7.8, 3.4, 5.3}});
        b = new Matrix((double[][])new double[][]{{0.2}, {0.4}});
        System.out.print("A = ");
        A.print(4, 2);
        System.out.print("b = ");
        b.print(4, 2);
        System.out.println("Solving Ax = b for x:");
        System.out.println("  Should be [0.0055; 0.0145; 0.0266; 0.0094; 0.0172] with lambda = 2.1381e-007");
        JamaUtils.regLeastSquares(A, b).print(6, 4);
        A = new Matrix((double[][])new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0}, {1.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0}, {1.0, 2.0, 4.0, 6.0, 8.0, 10.0, 3.0}});
        b = new Matrix((double[][])new double[][]{{1.0}, {2.0}, {7.0}});
        System.out.print("A = ");
        A.print(4, 2);
        System.out.print("b = ");
        b.print(4, 2);
        System.out.println("Solving Ax = b for x:");
        System.out.println("  Should be [0.0130; 0.0235; 0.0602; 0.0969; 0.1336; 0.1703; 0.0032] with lambda = 12.1354");
        JamaUtils.regLeastSquares(A, b).print(6, 4);
        A = new Matrix((double[][])new double[][]{{0.211, 0.485, 0.5893, -0.1, 0.1, -0.342, 0.8, 0.19, -0.2, -0.91}, {0.211, -0.2, 0.2, 0.48, 0.9, 0.94, -0.28, 0.7, 0.39, 0.1}, {0.211, -0.38, 0.85, 0.2, -0.38, 0.19, -0.1, 0.0, -0.48, 0.23}});
        b = new Matrix((double[][])new double[][]{{0.98}, {0.47}, {0.86}});
        System.out.print("A = ");
        A.print(4, 2);
        System.out.print("b = ");
        b.print(4, 2);
        System.out.println("Solving Ax = b for x:");
        System.out.println("  Should be [0.0989; 0.0017; 0.2891; 0.0632; 0.0311; 0.0583; 0.1062; 0.1008; -0.0915; -0.1193] with lambda = 1.7534");
        JamaUtils.regLeastSquares(A, b).print(6, 4);
        A = new Matrix((double[][])new double[][]{{0.211, 0.485, 0.5893}, {-0.1, 0.1, -0.342}, {0.8, 0.19, -0.2}, {0.211, -0.2, 0.2}, {0.48, 0.9, 0.94}, {-0.28, 0.7, 0.39}, {0.211, -0.38, 0.85}, {0.2, -0.38, 0.19}, {-0.1, 0.0, -0.48}});
        b = new Matrix((double[][])new double[][]{{0.15}, {0.7}, {0.8}, {0.5}, {-0.7}, {0.1}, {0.45}, {-0.7}, {-0.8}});
        System.out.print("A = ");
        A.print(4, 2);
        System.out.print("b = ");
        b.print(4, 2);
        System.out.println("Solving Ax = b for x:");
        System.out.println("  Should be [0.0910; -0.0500; -0.0350] with lambda = 1.8448");
        JamaUtils.regLeastSquares(A, b).print(6, 4);
        A = new Matrix((double[][])new double[][]{{1.0, -2.0, 3.0}, {-4.0, 5.0, 6.0}, {7.0, 8.0, -9.0}, {-10.0, 11.0, 12.0}, {13.0, -14.0, -15.0}});
        b = new Matrix((double[][])new double[][]{{0.5}, {-0.7}, {0.8}, {0.3}, {-0.4}});
        System.out.print("A = ");
        A.print(4, 2);
        System.out.print("b = ");
        b.print(4, 2);
        System.out.println("Solving Ax = b for x:");
        System.out.println("  Should be [0.0016;0.0079;-0.0013] with lambda = 32.5251");
        JamaUtils.regLeastSquares(A, b).print(6, 4);
    }

    private static class GCVFn
    implements Fmin_methods {
        double[] s2;
        Matrix fc;
        double rss0;
        double dof0;

        private GCVFn() {
        }

        public void setS2(double[] s2) {
            this.s2 = s2;
        }

        public void setFC(Matrix fc) {
            this.fc = fc;
        }

        public void setRSS0(double rss0) {
            this.rss0 = rss0;
        }

        public void setDOF0(double dof0) {
            this.dof0 = dof0;
        }

        @Override
        public double f_to_minimize(double lambda) {
            try {
                if (this.fc.getRowDimension() > this.s2.length) {
                    throw new IllegalStateException("Not enough s2's:  fc.numRows() > s2.length");
                }
                double lambda2 = Math.pow(lambda, 2.0);
                int rows = this.fc.getRowDimension();
                Matrix f = new Matrix(rows, 1);
                for (int i = 0; i < rows; ++i) {
                    double val = lambda2 / (this.s2[i] + lambda2);
                    f.set(i, 0, val);
                }
                double denominator = Math.pow(this.dof0 + MathUtils.sum(f.getColumnPackedCopy()), 2.0);
                for (int i = 0; i < this.fc.getRowDimension(); ++i) {
                    f.set(i, 0, f.get(i, 0) * this.fc.get(i, 0));
                }
                double numerator = Math.pow(f.normF(), 2.0) + this.rss0;
                return numerator / denominator;
            }
            catch (Exception e) {
                System.exit(1);
                return 0.0;
            }
        }
    }

    public static enum Function {
        MAX,
        MIN,
        MEAN;


        public double applyFunction(int v1, int v2) {
            switch (this) {
                case MAX: {
                    return Math.max(v1, v2);
                }
                case MIN: {
                    return Math.min(v1, v2);
                }
                case MEAN: {
                    return (double)(v1 + v2) / 2.0;
                }
            }
            throw new IllegalStateException("Unknown Function.");
        }

        public double applyFunction(double v1, double v2) {
            switch (this) {
                case MAX: {
                    return Math.max(v1, v2);
                }
                case MIN: {
                    return Math.min(v1, v2);
                }
                case MEAN: {
                    return (v1 + v2) / 2.0;
                }
            }
            throw new IllegalStateException("Unknown Function.");
        }
    }
}

