/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.data.conversion.MatlabArrayToSpreadSheet;
import adams.data.io.input.AbstractMultiSheetSpreadSheetReader;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.output.Mat5SpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.Struct;

public class Mat5SpreadSheetReader
extends AbstractMultiSheetSpreadSheetReader {
    private static final long serialVersionUID = -9113442938603879820L;
    protected String m_EntryName;
    protected String m_FieldName;

    public String globalInfo() {
        return "Reads Matlab .mat files (format 5)";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("entry-name", "entryName", (Object)"");
        this.m_OptionManager.add("field-name", "fieldName", (Object)"");
    }

    public void setEntryName(String value) {
        this.m_EntryName = value;
        this.reset();
    }

    public String getEntryName() {
        return this.m_EntryName;
    }

    public String entryNameTipText() {
        return "The name of the entry to retrieve, takes precedence over range.";
    }

    public void setFieldName(String value) {
        this.m_FieldName = value;
        this.reset();
    }

    public String getFieldName() {
        return this.m_FieldName;
    }

    public String fieldNameTipText() {
        return "The name of the field to retrieve from the struct.";
    }

    public String getFormatDescription() {
        return "Matlab .mat files";
    }

    public String[] getFormatExtensions() {
        return new String[]{"mat"};
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return new Mat5SpreadSheetWriter();
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.FILE;
    }

    protected SpreadSheet convert(Array array) throws Exception {
        MatlabArrayToSpreadSheet conv = new MatlabArrayToSpreadSheet();
        conv.setInput(array);
        this.m_LastError = conv.convert();
        if (this.m_LastError == null) {
            return (SpreadSheet)conv.getOutput();
        }
        this.getLogger().severe(this.m_LastError);
        return null;
    }

    protected SpreadSheet doRead(File file) {
        if (this.m_EntryName.isEmpty()) {
            this.getLogger().warning("Entry name is empty, reading first entry!");
        }
        try {
            Mat5File mat5 = Mat5.readFromFile((File)file.getAbsoluteFile());
            if (this.isLoggingEnabled()) {
                for (MatFile.Entry entry : mat5.getEntries()) {
                    this.getLogger().info("Entry: " + entry.getName());
                }
            }
            String entryName = this.m_EntryName;
            Array array = null;
            for (MatFile.Entry entry : mat5.getEntries()) {
                if (!entry.getName().equals(entryName) && !entryName.isEmpty()) continue;
                array = entry.getValue();
                entryName = entry.getName();
                break;
            }
            if (array != null) {
                SpreadSheet sheet;
                if (array instanceof Struct) {
                    array = ((Struct)array).get(this.m_FieldName);
                }
                if ((sheet = this.convert(array)) != null) {
                    sheet.setName(entryName);
                }
                return sheet;
            }
            this.m_LastError = "Failed to load entry: " + this.m_EntryName;
            this.getLogger().severe(this.m_LastError);
        }
        catch (Exception e) {
            this.m_LastError = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to read: " + file), (Throwable)e);
        }
        return null;
    }

    protected List<SpreadSheet> doReadRange(File file) {
        ArrayList<SpreadSheet> result = new ArrayList<SpreadSheet>();
        if (!this.m_EntryName.isEmpty()) {
            SpreadSheet sheet = this.read(file);
            if (sheet != null) {
                result.add(sheet);
            }
            return result;
        }
        try {
            Mat5File mat5 = Mat5.readFromFile((File)file.getAbsoluteFile());
            if (this.isLoggingEnabled()) {
                for (MatFile.Entry entry : mat5.getEntries()) {
                    this.getLogger().info("Entry: " + entry.getName());
                }
            }
            this.m_SheetRange.setMax(mat5.getNumEntries());
            TIntHashSet indices = new TIntHashSet(this.m_SheetRange.getIntIndices());
            int i = 0;
            for (MatFile.Entry entry : mat5.getEntries()) {
                Array array;
                SpreadSheet sheet;
                if (indices.contains(i) && (sheet = this.convert(array = entry.getValue())) != null) {
                    sheet.setName(entry.getName());
                    result.add(sheet);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.m_LastError = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to read: " + file), (Throwable)e);
        }
        return result;
    }

    public static void main(String[] args) {
        Mat5SpreadSheetReader.runReader(Environment.class, Mat5SpreadSheetReader.class, (String[])args);
    }
}

