/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.io.PlaceholderFile;
import adams.data.conversion.SpreadSheetToMatlabArray;
import adams.data.io.input.Mat5SpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.AbstractMultiSheetSpreadSheetWriter;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import java.io.File;
import java.util.HashSet;
import java.util.logging.Level;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Sinks;

public class Mat5SpreadSheetWriter
extends AbstractMultiSheetSpreadSheetWriter {
    private static final long serialVersionUID = 6981291532332284718L;

    public String globalInfo() {
        return "Writes Matlab .mat files (format 5)";
    }

    public String getFormatDescription() {
        return new Mat5SpreadSheetReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new Mat5SpreadSheetReader().getFormatExtensions();
    }

    public SpreadSheetReader getCorrespondingReader() {
        return new Mat5SpreadSheetReader();
    }

    protected AbstractSpreadSheetWriter.OutputType getOutputType() {
        return AbstractSpreadSheetWriter.OutputType.FILE;
    }

    protected boolean doWrite(SpreadSheet[] content, String filename) {
        int i;
        String[] names = new String[content.length];
        HashSet<String> unique = new HashSet<String>();
        for (i = 0; i < content.length; ++i) {
            names[i] = content[i].getName();
            int n = 0;
            while (unique.contains(names[i])) {
                names[i] = content[i].getName() + "-" + ++n;
            }
            unique.add(names[i]);
        }
        Mat5File mat5 = Mat5.newMatFile();
        SpreadSheetToMatlabArray conv = new SpreadSheetToMatlabArray();
        for (i = 0; i < content.length; ++i) {
            conv.setInput(content[i]);
            String msg = conv.convert();
            if (msg != null) {
                this.getLogger().severe("Failed to convert spreadsheet #" + (i + 1) + " into Matlab array:\n" + msg);
                return false;
            }
            Array array = (Array)conv.getOutput();
            mat5.addArray(names[i], array);
        }
        try {
            mat5.writeTo(Sinks.newStreamingFile((File)new PlaceholderFile(filename).getAbsoluteFile()));
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to write to file: " + filename, (Throwable)e);
            return false;
        }
        return true;
    }
}

