/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseClassname;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.core.ObjectRetriever;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Map;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.Array;

public class Mat5FileAddMap
extends AbstractTransformer {
    private static final long serialVersionUID = -4381778255320714964L;
    protected ObjectRetriever m_Retriever;

    public String globalInfo() {
        return "Adds the elements of a map to the matlab file object using the names from the map.\nThe map can be retrieved from a callable actor or from storage.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("retrieval-type", "retrievalType", (Object)ObjectRetriever.RetrievalType.AUTO);
        this.m_OptionManager.add("object-actor", "objectActor", (Object)new CallableActorReference());
        this.m_OptionManager.add("object-storage", "objectStorage", (Object)new StorageName());
        this.m_OptionManager.add("object-type", "objectType", (Object)new BaseClassname(Object.class));
    }

    protected void initialize() {
        super.initialize();
        this.m_Retriever = new ObjectRetriever();
        this.m_Retriever.setFlowContext((Actor)this);
    }

    public void setRetrievalType(ObjectRetriever.RetrievalType value) {
        this.m_Retriever.setRetrievalType(value);
        this.reset();
    }

    public ObjectRetriever.RetrievalType getRetrievalType() {
        return this.m_Retriever.getRetrievalType();
    }

    public String retrievalTypeTipText() {
        return this.m_Retriever.retrievalTypeTipText();
    }

    public void setObjectActor(CallableActorReference value) {
        this.m_Retriever.setObjectActor(value);
        this.reset();
    }

    public CallableActorReference getObjectActor() {
        return this.m_Retriever.getObjectActor();
    }

    public String objectActorTipText() {
        return this.m_Retriever.objectActorTipText();
    }

    public void setObjectStorage(StorageName value) {
        this.m_Retriever.setObjectStorage(value);
        this.reset();
    }

    public StorageName getObjectStorage() {
        return this.m_Retriever.getObjectStorage();
    }

    public String objectStorageTipText() {
        return this.m_Retriever.objectStorageTipText();
    }

    public void setObjectType(BaseClassname value) {
        this.m_Retriever.setObjectType(value);
        this.reset();
    }

    public BaseClassname getObjectType() {
        return this.m_Retriever.getObjectType();
    }

    public String objectTypeTipText() {
        return this.m_Retriever.objectTypeTipText();
    }

    public Class[] accepts() {
        return new Class[]{Mat5File.class};
    }

    public Class[] generates() {
        return new Class[]{Mat5File.class};
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"retrievalType", (Object)this.getRetrievalType(), (String)"type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"objectSource", (Object)this.getObjectActor(), (String)", source: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"objectStorage", (Object)this.getObjectStorage(), (String)", storage: ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        Mat5File mat5 = (Mat5File)this.m_InputToken.getPayload(Mat5File.class);
        MessageCollection errors = new MessageCollection();
        Object obj = this.m_Retriever.getObject(errors);
        if (!errors.isEmpty()) {
            result = errors.toString();
        } else if (!(obj instanceof Map)) {
            result = "Retrieved object is not a map: " + Utils.classToString((Object)obj);
        }
        if (result == null) {
            Map map = (Map)obj;
            try {
                for (Object key : map.keySet()) {
                    Object value;
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Adding value for key: " + key);
                    }
                    if ((value = map.get(key)) instanceof Array) {
                        String keyStr = "" + key;
                        mat5.addArray(keyStr, (Array)value);
                        continue;
                    }
                    this.getLogger().warning("Value '" + key + "' is not a " + Utils.classToString(Array.class) + " but: " + Utils.classToString(value));
                }
                this.m_OutputToken = new Token((Object)mat5);
            }
            catch (Exception e) {
                result = this.handleException("Failed to add entries from map!", e);
            }
        }
        return result;
    }
}

