/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.DataInfoActor;
import adams.flow.transformer.AbstractArrayProvider;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.MatFile;

public class Mat5FileInfo
extends AbstractArrayProvider
implements DataInfoActor {
    private static final long serialVersionUID = 8251699709312918726L;
    protected InfoType m_Type;
    protected boolean m_Sort;

    public String globalInfo() {
        return "Provides information from a .mat file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.NUM_ENTRIES);
        this.m_OptionManager.add("sort", "sort", (Object)true);
    }

    public String outputArrayTipText() {
        return "If enabled, outputs the items as array rather than one-by-one.";
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    public void setSort(boolean value) {
        this.m_Sort = value;
        this.reset();
    }

    public boolean getSort() {
        return this.m_Sort;
    }

    public String sortTipText() {
        return "If enabled, lists (eg names, values) are sorted.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class, Mat5File.class};
    }

    protected Class getItemClass() {
        switch (this.m_Type) {
            case DESCRIPTION: {
                return String.class;
            }
            case VERSION: {
                return Integer.class;
            }
            case BYTE_ORDER: {
                return String.class;
            }
            case NUM_ENTRIES: {
                return Integer.class;
            }
            case ENTRY_NAMES: {
                return String.class;
            }
        }
        throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
        HashSet<InfoType> types = new HashSet<InfoType>(Arrays.asList(InfoType.ENTRY_NAMES));
        if (types.contains((Object)this.m_Type) || QuickInfoHelper.hasVariable((OptionHandler)this, (String)"type")) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"sort", (boolean)this.m_Sort, (String)(this.m_Sort ? "sorted" : "unsorted"), (String)", ");
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        Mat5File mat5 = null;
        PlaceholderFile file = null;
        if (this.m_InputToken.hasPayload(String.class)) {
            file = new PlaceholderFile((String)this.m_InputToken.getPayload(String.class));
        } else if (this.m_InputToken.hasPayload(File.class)) {
            file = new PlaceholderFile((File)this.m_InputToken.getPayload(File.class));
        } else if (this.m_InputToken.hasPayload(Mat5File.class)) {
            mat5 = (Mat5File)this.m_InputToken.getPayload(Mat5File.class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (file != null) {
            try {
                mat5 = Mat5.readFromFile((File)file.getAbsoluteFile());
            }
            catch (Exception e) {
                result = this.handleException("Failed to load file: " + file, e);
            }
        }
        if (result == null) {
            try {
                this.m_Queue.clear();
                switch (this.m_Type) {
                    case DESCRIPTION: {
                        this.m_Queue.add(mat5.getDescription());
                        break;
                    }
                    case VERSION: {
                        this.m_Queue.add(Integer.valueOf(mat5.getVersion()));
                        break;
                    }
                    case BYTE_ORDER: {
                        this.m_Queue.add(mat5.getByteOrder().toString());
                        break;
                    }
                    case NUM_ENTRIES: {
                        this.m_Queue.add(mat5.getNumEntries());
                        break;
                    }
                    case ENTRY_NAMES: {
                        for (MatFile.Entry entry : mat5.getEntries()) {
                            this.m_Queue.add(entry.getName());
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
                    }
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to generate information: " + (Object)((Object)this.m_Type), e);
            }
        }
        return result;
    }

    public static enum InfoType {
        DESCRIPTION,
        VERSION,
        BYTE_ORDER,
        NUM_ENTRIES,
        ENTRY_NAMES;

    }
}

