/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;

public class Mat5FileReader
extends AbstractTransformer {
    private static final long serialVersionUID = -927035643528560248L;

    public String globalInfo() {
        return "Loads a Matlab file in mat5 format.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{Mat5File.class};
    }

    protected String doExecute() {
        String result = null;
        PlaceholderFile file = this.m_InputToken.hasPayload(String.class) ? new PlaceholderFile((String)this.m_InputToken.getPayload(String.class)) : new PlaceholderFile((File)this.m_InputToken.getPayload(File.class));
        try {
            Mat5File mat5 = Mat5.readFromFile((File)file.getAbsoluteFile());
            this.m_OutputToken = new Token((Object)mat5);
        }
        catch (Exception e) {
            result = this.handleException("Failed to load matlab file: " + file, e);
        }
        return result;
    }
}

