/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.Mat5ArrayToString;
import adams.data.conversion.StringToMat5Array;
import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.types.Matrix;

public class StringToMat5ArrayTest
extends AbstractConversionTestCase {
    public StringToMat5ArrayTest(String name) {
        super(name);
    }

    protected String toString(Object data) {
        Mat5ArrayToString conv = new Mat5ArrayToString();
        conv.setInput(data);
        String msg = conv.convert();
        if (msg == null) {
            return "" + conv.getOutput();
        }
        return super.toString(data);
    }

    protected Object[] getRegressionInput() {
        Matrix mat = Mat5.newMatrix((int[])new int[]{2, 2});
        mat.setDouble(new int[]{0, 0}, 1.0);
        mat.setDouble(new int[]{0, 1}, 2.0);
        mat.setDouble(new int[]{1, 0}, 3.0);
        mat.setDouble(new int[]{1, 1}, 4.0);
        return new Object[]{"[1, 2; 3, 4]", "[1.1, 2.2, 3.3; 4.4, 5.5, 6.6; 7.7, 8.8, 9.9]"};
    }

    protected Conversion[] getRegressionSetups() {
        return new Conversion[]{new StringToMat5Array()};
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(StringToMat5ArrayTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        StringToMat5ArrayTest.runTest((Test)StringToMat5ArrayTest.suite());
    }
}

