/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.conversion.Conversion;
import adams.data.conversion.MapToString;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.flowrestart.AbstractFlowRestartManager;
import adams.flow.control.flowrestart.NullManager;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.NewMat5Matrix;
import adams.flow.transformer.Convert;
import adams.flow.transformer.Mat5ArrayInfo;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class Mat5ArrayInfoTest
extends AbstractFlowTest {
    public Mat5ArrayInfoTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(Mat5ArrayInfoTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            NewMat5Matrix newmat5matrix = new NewMat5Matrix();
            actors.add(newmat5matrix);
            Mat5ArrayInfo mat5arrayinfo = new Mat5ArrayInfo();
            AbstractArgumentOption argOption = (AbstractArgumentOption)mat5arrayinfo.getOptionManager().findByProperty("type");
            mat5arrayinfo.setType((Mat5ArrayInfo.InfoType)argOption.valueOf("ALL"));
            actors.add(mat5arrayinfo);
            Convert convert = new Convert();
            MapToString maptostring = new MapToString();
            maptostring.setSortKeys(true);
            convert.setConversion((Conversion)maptostring);
            actors.add(convert);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
            NullManager nullmanager = new NullManager();
            flow.setFlowRestartManager((AbstractFlowRestartManager)nullmanager);
        }
        catch (Exception e) {
            Mat5ArrayInfoTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        Mat5ArrayInfoTest.runTest((Test)Mat5ArrayInfoTest.suite());
    }
}

