/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.Mat5ArrayElementIndex;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.conversion.Conversion;
import adams.data.conversion.Mat5ArrayToString;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.flowrestart.AbstractFlowRestartManager;
import adams.flow.control.flowrestart.NullManager;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.Convert;
import adams.flow.transformer.Mat5ArraySubset;
import adams.flow.transformer.Mat5FileGetArray;
import adams.flow.transformer.Mat5FileReader;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class Mat5ArraySubsetTest
extends AbstractFlowTest {
    public Mat5ArraySubsetTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("Indian_pines_corrected.mat");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("Indian_pines_corrected.mat");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(Mat5ArraySubsetTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/Indian_pines_corrected.mat"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            filesupplier.setUseForwardSlashes(true);
            actors.add(filesupplier);
            Mat5FileReader mat5filereader = new Mat5FileReader();
            actors.add(mat5filereader);
            Mat5FileGetArray mat5filegetarray = new Mat5FileGetArray();
            argOption = (AbstractArgumentOption)mat5filegetarray.getOptionManager().findByProperty("entryName");
            mat5filegetarray.setEntryName((String)argOption.valueOf("indian_pines_corrected"));
            actors.add(mat5filegetarray);
            Mat5ArraySubset mat5arraysubset = new Mat5ArraySubset();
            argOption = (AbstractArgumentOption)mat5arraysubset.getOptionManager().findByProperty("index");
            mat5arraysubset.setIndex((Mat5ArrayElementIndex)argOption.valueOf(";;8"));
            mat5arraysubset.setZeroBasedIndex(true);
            actors.add(mat5arraysubset);
            Convert conv = new Convert();
            conv.setConversion((Conversion)new Mat5ArrayToString());
            actors.add(conv);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
            NullManager nullmanager = new NullManager();
            flow.setFlowRestartManager((AbstractFlowRestartManager)nullmanager);
        }
        catch (Exception e) {
            Mat5ArraySubsetTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        Mat5ArraySubsetTest.runTest((Test)Mat5ArraySubsetTest.suite());
    }
}

