/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.flowrestart.AbstractFlowRestartManager;
import adams.flow.control.flowrestart.NullManager;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.Mat5FileInfo;
import adams.flow.transformer.Mat5FileReader;
import adams.flow.transformer.StringJoin;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class Mat5FileInfoTest
extends AbstractFlowTest {
    public Mat5FileInfoTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("Indian_pines_corrected.mat");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("Indian_pines_corrected.mat");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(Mat5FileInfoTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/Indian_pines_corrected.mat"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            filesupplier.setUseForwardSlashes(true);
            actors.add(filesupplier);
            Mat5FileReader mat5filereader = new Mat5FileReader();
            actors.add(mat5filereader);
            Mat5FileInfo mat5fileinfo = new Mat5FileInfo();
            mat5fileinfo.setOutputArray(true);
            argOption = (AbstractArgumentOption)mat5fileinfo.getOptionManager().findByProperty("type");
            mat5fileinfo.setType((Mat5FileInfo.InfoType)argOption.valueOf("ENTRY_NAMES"));
            actors.add(mat5fileinfo);
            StringJoin stringjoin = new StringJoin();
            argOption = (AbstractArgumentOption)stringjoin.getOptionManager().findByProperty("glue");
            stringjoin.setGlue((String)argOption.valueOf("\n"));
            actors.add(stringjoin);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
            NullManager nullmanager = new NullManager();
            flow.setFlowRestartManager((AbstractFlowRestartManager)nullmanager);
        }
        catch (Exception e) {
            Mat5FileInfoTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        Mat5FileInfoTest.runTest((Test)Mat5FileInfoTest.suite());
    }
}

