/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.Utils;
import adams.core.base.AbstractBaseString;
import adams.data.statistics.StatUtils;

public class Mat5ArrayDimensions
extends AbstractBaseString {
    private static final long serialVersionUID = -8138523980228144441L;
    public static final String SEPARATOR = ";";

    public Mat5ArrayDimensions() {
        this("");
    }

    public Mat5ArrayDimensions(String index) {
        super(index);
    }

    public Mat5ArrayDimensions(int[] index) {
        super(Utils.flatten((Object[])StatUtils.toNumberArray((int[])index), (String)SEPARATOR));
    }

    public boolean isValid(String value) {
        boolean result;
        boolean bl = result = value.length() > 0 && !value.startsWith(SEPARATOR) && !value.endsWith(SEPARATOR);
        if (result) {
            String[] parts = value.split(SEPARATOR);
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].trim().length() == 0) {
                    result = false;
                    break;
                }
                if (Utils.isInteger((String)parts[i].trim())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public int[] indexValue() {
        int[] result;
        if (this.getValue().isEmpty()) {
            result = new int[]{};
        } else {
            String[] parts = this.getValue().split(SEPARATOR);
            result = new int[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                result[i] = Integer.parseInt(parts[i]);
            }
        }
        return result;
    }

    public String getTipText() {
        return "Array dimensions format: \"DIM1;DIM2;...\".";
    }
}

