/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.Utils;
import adams.core.base.AbstractBaseString;
import adams.data.statistics.StatUtils;
import gnu.trove.list.array.TIntArrayList;
import us.hebi.matlab.mat.types.Array;

public class Mat5ArrayElementIndex
extends AbstractBaseString {
    private static final long serialVersionUID = -8138523980228144441L;
    public static final String SEPARATOR = ";";

    public Mat5ArrayElementIndex() {
        this("");
    }

    public Mat5ArrayElementIndex(String index) {
        super(index);
    }

    public Mat5ArrayElementIndex(int[] index) {
        super(Utils.flatten((Object[])StatUtils.toNumberArray((int[])index), (String)SEPARATOR));
    }

    public boolean isValid(String value) {
        boolean result;
        boolean bl = result = value.length() > 0;
        if (result) {
            String[] parts = value.split(SEPARATOR);
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].trim().length() == 0 || Utils.isInteger((String)parts[i].trim())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public int[] indexValue() {
        return this.indexValue(false);
    }

    public int[] indexValue(boolean convertToZeroBased) {
        int i;
        int[] result;
        if (this.getValue().isEmpty()) {
            result = new int[]{};
        } else {
            String[] parts = this.getValue().split(SEPARATOR);
            result = new int[parts.length];
            for (i = 0; i < parts.length; ++i) {
                result[i] = parts[i].trim().length() == 0 ? -1 : Integer.parseInt(parts[i]);
            }
        }
        if (convertToZeroBased) {
            for (i = 0; i < result.length; ++i) {
                if (result[i] <= 0) continue;
                int n = i;
                result[n] = result[n] - 1;
            }
        }
        return result;
    }

    public int[] openDimensions() {
        TIntArrayList result = new TIntArrayList();
        int[] index = this.indexValue();
        for (int i = 0; i < index.length; ++i) {
            if (index[i] != -1) continue;
            result.add(i);
        }
        return result.toArray();
    }

    public boolean isCompatible(Array array) {
        int[] index = this.indexValue();
        return index.length == array.getNumDimensions();
    }

    public String getTipText() {
        return "Array element index using format: \"DIM1;DIM2;...\" with empty DIM signifying to iterate over all values.";
    }
}

