/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Matrix;

public class DoubleMatrixToMat5Array
extends AbstractConversion {
    private static final long serialVersionUID = 5826890056883195059L;

    public String globalInfo() {
        return "Turns a double matrix into a 2-dimensional Matlab matrix array.";
    }

    public Class accepts() {
        return Double[][].class;
    }

    public Class generates() {
        return Array.class;
    }

    protected String checkData() {
        Double[][] input;
        String result = super.checkData();
        if (result == null && (input = (Double[][])this.m_Input).length == 0) {
            throw new IllegalStateException("No data in double matrix!");
        }
        return result;
    }

    protected Object doConvert() throws Exception {
        Double[][] input = (Double[][])this.m_Input;
        Matrix result = Mat5.newMatrix((int)input.length, (int)input[0].length);
        for (int y = 0; y < input.length; ++y) {
            for (int x = 0; x < input[0].length; ++x) {
                result.setDouble(y, x, input[y][x].doubleValue());
            }
        }
        return result;
    }
}

