/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.MapToMat5Struct;
import java.util.Map;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.Struct;

public class MapToMat5File
extends AbstractConversion {
    private static final long serialVersionUID = 4205211480274516691L;

    public String globalInfo() {
        return "Converts a map into a Matlab file object.\nSupported nested elements:\n- " + Utils.classToString(Map.class) + "\n- Matlab array/struct\n- spreadsheet\n- Double matrix";
    }

    public Class accepts() {
        return Map.class;
    }

    public Class generates() {
        return Mat5File.class;
    }

    protected Object doConvert() throws Exception {
        Map input = (Map)this.m_Input;
        Mat5File result = Mat5.newMatFile();
        MapToMat5Struct conv = new MapToMat5Struct();
        conv.setInput(input);
        String msg = conv.convert();
        if (msg == null) {
            Struct struct = (Struct)conv.getOutput();
            for (String f : struct.getFieldNames()) {
                result.addArray(f, struct.get(f));
            }
        } else {
            conv.cleanUp();
            throw new Exception("Failed to turn map into struct:\n" + msg);
        }
        conv.cleanUp();
        return result;
    }
}

