/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.DoubleMatrixToMat5Array;
import adams.data.conversion.SpreadSheetToMat5Array;
import adams.data.spreadsheet.SpreadSheet;
import java.util.Map;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Struct;

public class MapToMat5Struct
extends AbstractConversion {
    private static final long serialVersionUID = 2829495301196516668L;

    public String globalInfo() {
        return "Converts a map into a Matlab struct object.\nSupported nested elements:\n- " + Utils.classToString(Map.class) + "\n- Matlab array/struct\n- spreadsheet\n- Double matrix";
    }

    public Class accepts() {
        return Map.class;
    }

    public Class generates() {
        return Struct.class;
    }

    protected Array convert(Object object) {
        Array result = null;
        if (object instanceof Array) {
            result = (Array)object;
        } else if (object instanceof Map) {
            result = this.convert((Map)object);
        } else if (object instanceof Double[][]) {
            DoubleMatrixToMat5Array dm2a = new DoubleMatrixToMat5Array();
            dm2a.setInput(object);
            String msg = dm2a.convert();
            if (msg == null) {
                result = (Array)dm2a.getOutput();
            } else {
                this.getLogger().warning(msg);
            }
            dm2a.cleanUp();
        } else if (object instanceof SpreadSheet) {
            SpreadSheetToMat5Array sp2a = new SpreadSheetToMat5Array();
            sp2a.setInput(object);
            String msg = sp2a.convert();
            if (msg == null) {
                result = (Array)sp2a.getOutput();
            } else {
                this.getLogger().warning(msg);
            }
            sp2a.cleanUp();
        }
        if (result == null) {
            this.getLogger().warning("Cannot convert to Matlab structure: " + Utils.classToString((Object)object));
        }
        return result;
    }

    protected Struct convert(Map map) {
        Struct result = Mat5.newStruct();
        for (Object k : map.keySet()) {
            String key = "" + k;
            Array array = this.convert(map.get(k));
            if (array != null) {
                result.set(key, array);
                continue;
            }
            this.getLogger().warning("Failed to convert map value '" + key + "' into array!");
        }
        return result;
    }

    protected Object doConvert() throws Exception {
        return this.convert((Map)this.m_Input);
    }
}

