/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractConversion;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Matrix;

public class Mat5ArrayToDoubleMatrix
extends AbstractConversion {
    private static final long serialVersionUID = 1324403475035054937L;

    public String globalInfo() {
        return "Converts a 2-dimensional Matlab array into a double matrix.";
    }

    public Class accepts() {
        return Array.class;
    }

    public Class generates() {
        return Double[][].class;
    }

    protected String checkData() {
        Object result = super.checkData();
        if (result == null) {
            Array array = (Array)this.m_Input;
            if (array.getNumDimensions() > 2) {
                result = "Cannot handle arrays with more than two dimensions, received: " + array.getNumDimensions();
            } else if (!(array instanceof Matrix)) {
                result = "Array is not of type " + Utils.classToString(Matrix.class) + "!";
            }
        }
        return result;
    }

    protected Object doConvert() throws Exception {
        Array array = (Array)this.m_Input;
        Matrix matrix = (Matrix)array;
        Double[][] result = new Double[matrix.getNumRows()][matrix.getNumCols()];
        for (int n = 0; n < array.getNumRows(); ++n) {
            for (int i = 0; i < array.getNumCols(); ++i) {
                result[n][i] = matrix.getDouble(n, i);
            }
        }
        return result;
    }
}

